package ru.yandex.autotests.directintapi.bstransport.b2b.prepare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.autotests.direct.db.steps.base.DirectDbStepsException;
import ru.yandex.autotests.direct.db.steps.base.LimitOffsetStepCallable;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;
import ru.yandex.autotests.directintapi.bstransport.b2b.utils.TransportB2BBeanMongoHelper;
import ru.yandex.autotests.directintapi.bstransport.b2b.utils.TransportB2BMongoBean;
import ru.yandex.autotests.directintapi.bstransport.b2b.utils.TransportB2BProperties;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 11.11.16.
 * https://st.yandex-team.ru/TESTIRT-10501
 */
public abstract class BaseCampaignsB2BPrepareTest {

    private static final int SHARDS_AMOUNT = 21;
    private static final int MAX_GROUPS = 50;
    private static final int MAX_PHRASES = 400;
    private static final int MAX_BANNERS = 200;
    private static final TransportB2BBeanMongoHelper mongoHelper = new TransportB2BBeanMongoHelper();
    private static final int CAMPAIGNS_COUNT = new TransportB2BProperties().getCampaignsQuantity();
    private static final String LAST_PROD_CID_DIRECT_BALANCE = "LAST_PROD_CID_DIRECT_BALANCE";

    private static DarkSideSteps darkSideSteps = new DarkSideSteps();
    boolean addUsedCids = false;
    private Long lastProdCidDirectBalance;

    @Before
    public void before() {
        mongoHelper.deleteCampaignsForClass(this.getClass());
    }

    @Test
    @Title("Получение номеров кампаний для теста")
    public void campaignB2BPrepareTest() {
        Collection<Long> collectedCidList = mongoHelper.getAllCids();
        List<Long> foundCids = findAndAddToMongo(collectedCidList, CAMPAIGNS_COUNT);

        int foundSize = foundCids.size();
        if (foundSize < CAMPAIGNS_COUNT && addUsedCids) {
            foundSize += findAndAddToMongo(foundCids, CAMPAIGNS_COUNT - foundSize).size();
        }

        assertThat("В базе стенда " + darkSideSteps.getHost() + " не нашлось нужного количества кампаний("
                        + CAMPAIGNS_COUNT + "), " + "записали сколько нашлось",
                foundSize, greaterThanOrEqualTo(CAMPAIGNS_COUNT));
    }

    private List<Long> findAndAddToMongo(Collection<Long> cidsToIgnore, int sizeToFind) {
        int offset = 0;
        List<Long> cidsList = new ArrayList<>();
        for (int shard = 1; shard <= SHARDS_AMOUNT; shard++) {
            List<Long> inShardCidList = darkSideSteps.getDirectJooqDbSteps().useShard(shard).transportSteps()
                    .getCampaignsIds(getCampaignsCallable(
                            CAMPAIGNS.CID.le(getLastProdCidDirectBalance()).and(CAMPAIGNS.CID.notIn(cidsToIgnore))),
                            offset, sizeToFind - cidsList.size(), MAX_GROUPS, MAX_PHRASES, MAX_BANNERS);

            for (Long cid : inShardCidList) {
                mongoHelper.addMongoBean(
                        new TransportB2BMongoBean()
                                .withCid(cid)
                                .withShard(shard)
                                .withLastFailed(true)
                                .withClassName(TransportB2BBeanMongoHelper.getClassNameForBean(this.getClass()))
                );
            }

            cidsList.addAll(inShardCidList);
            if (cidsList.size() >= sizeToFind) {
                break;
            }
        }

        return cidsList;
    }

    long getLastProdCidDirectBalance() {
        if (lastProdCidDirectBalance == null) {
            String value = darkSideSteps.getDirectJooqDbSteps().ppcPropertiesSteps()
                    .getPropertyValue(LAST_PROD_CID_DIRECT_BALANCE);
            if (value == null) {
                throw new DirectDbStepsException("В таблице ppcdict.ppc_properties не найдено свойства " + LAST_PROD_CID_DIRECT_BALANCE);
            }
            lastProdCidDirectBalance = Long.valueOf(value);
        }
        return lastProdCidDirectBalance;
    }

    protected abstract LimitOffsetStepCallable<List<Long>> getCampaignsCallable(Condition baseCondition);
}
