package ru.yandex.autotests.directintapi.bstransport.b2b.prepare;

import java.util.List;

import org.jooq.Condition;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Campaigns;
import ru.yandex.autotests.direct.db.steps.base.LimitOffsetStepCallable;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMP_OPTIONS;

@Aqua.Test
@Features(FeatureNames.TRANSPORT_B2B_PREPARE)
@Title("Общая стратегия на кампанию; autobudget_avg_cpc_per_camp - на сети, удерживать CPC в среднем, по всем фильтрам")
public class CampaignWithAutoBudgetAvgCpcPerCampPrepareTest extends BaseCampaignsB2BPrepareTest {

    @Override
    protected LimitOffsetStepCallable<List<Long>> getCampaignsCallable(Condition baseCondition) {
        return (db, limit, offset) -> db.select(Campaigns.CAMPAIGNS.CID).from(Campaigns.CAMPAIGNS)
                .leftJoin(CAMP_OPTIONS).on(Campaigns.CAMPAIGNS.CID.eq(CAMP_OPTIONS.CID))
                .where(baseCondition.and(CAMPAIGNS.ORDERID.gt(0L))
                        .and(CAMPAIGNS.STRATEGY_NAME.eq(CampaignsStrategyName.autobudget_avg_cpc_per_camp)))
                .orderBy(Campaigns.CAMPAIGNS.CID.desc())
                .limit(offset, limit)
                .fetch(Campaigns.CAMPAIGNS.CID);
    }
}
