package ru.yandex.autotests.directintapi.bstransport.b2b.prepare;

import java.util.List;

import org.jooq.Condition;

import ru.yandex.autotests.direct.db.steps.base.LimitOffsetStepCallable;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CampOptions.CAMP_OPTIONS;

/**
 * Версия теста, в которой кампании получаются по условию, в котором упоминаются только стобцы таблицы campaigns
 */
public abstract class CampaignsOnlyB2BPrepareTest extends BaseCampaignsB2BPrepareTest {
    protected abstract Condition getCampaignsCondition();

    @Override
    protected LimitOffsetStepCallable<List<Long>> getCampaignsCallable(Condition baseCondition) {
        return (db, limit, offset) -> db.select(CAMPAIGNS.CID).from(CAMPAIGNS)
                .leftJoin(CAMP_OPTIONS).on(CAMPAIGNS.CID.eq(CAMP_OPTIONS.CID))
                .where(baseCondition.and(getCampaignsCondition()))
                .orderBy(CAMPAIGNS.CID.desc())
                .limit(offset, limit)
                .fetch(CAMPAIGNS.CID);
    }
}
