package ru.yandex.autotests.directintapi.bstransport.b2b.prepare;

import org.jooq.Condition;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsAutobudget;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusactive;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS;
import static ru.yandex.autotests.direct.db.utils.MysqlDSLUtils.jsonExtract;

/**
 * Created by buhter on 11.11.16.
 * https://st.yandex-team.ru/TESTIRT-10501
 */
@Aqua.Test
@Title("Кампании с оптимизацией по целям Метрики")
@Features(FeatureNames.TRANSPORT_B2B_PREPARE)
public class CampaignsWithAutobudgetGoalIDPrepareTest extends CampaignsOnlyB2BPrepareTest {

    @Override
    protected Condition getCampaignsCondition() {
        return CAMPAIGNS.ORDERID.gt(0L)
                .and(CAMPAIGNS.TYPE.eq(CampaignsType.text))
                .and(CAMPAIGNS.STATUSACTIVE.eq(CampaignsStatusactive.Yes))
                .and(CAMPAIGNS.ARCHIVED.eq(CampaignsArchived.No))
                .and(CAMPAIGNS.AUTOBUDGET.eq(CampaignsAutobudget.Yes))
                .and(jsonExtract(CAMPAIGNS.STRATEGY_DATA, "$.goal_id", String.class).likeRegex("[1-9]+"));
    }
}