package ru.yandex.autotests.directintapi.bstransport.b2b.prepare;

import java.util.List;

import org.jooq.Condition;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusempty;
import ru.yandex.autotests.direct.db.steps.base.LimitOffsetStepCallable;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BANNERS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersLanguage.No;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersLanguage.Yes;

@Aqua.Test
@Title("Кампании, содержащие баннеры с заполненными языками")
@Features(FeatureNames.TRANSPORT_B2B_PREPARE)
public class CampaignsWithBannersWithLanguagesPrepareTest extends BaseCampaignsB2BPrepareTest {

    @Override
    protected LimitOffsetStepCallable<List<Long>> getCampaignsCallable(Condition baseCondition) {
        return (db, limit, offset) -> db.selectDistinct(CAMPAIGNS.CID)
                .from(BANNERS)
                .join(CAMPAIGNS).on(CAMPAIGNS.CID.eq(BANNERS.CID))
                .where(baseCondition
                        .and(CAMPAIGNS.ORDERID.gt(0L))
                        .and(CAMPAIGNS.CID.gt(getLastProdCidDirectBalance() / 5))
                        .and(CAMPAIGNS.STATUSEMPTY.eq(CampaignsStatusempty.No))
                        .and(CAMPAIGNS.ARCHIVED.eq(CampaignsArchived.No))
                        .and(BANNERS.BANNERID.gt(0L)))
                .and(BANNERS.LANGUAGE.notIn(Yes, No))
                .limit(offset, limit)
                .fetch(CAMPAIGNS.CID);
    }
}
