package ru.yandex.autotests.directintapi.bstransport.b2b.prepare;

import java.math.BigDecimal;

import org.jooq.Condition;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS;

/**
 * Created by buhter on 11.11.16.
 * https://st.yandex-team.ru/TESTIRT-10501
 */
@Aqua.Test
@Title("Кампании с ограничением дневного бюджета")
@Features(FeatureNames.TRANSPORT_B2B_PREPARE)
public class CampaignsWithDayBudgetPrepareTest extends CampaignsOnlyB2BPrepareTest {

    public CampaignsWithDayBudgetPrepareTest() {
        this.addUsedCids = true;
    }

    @Override
    protected Condition getCampaignsCondition() {
        return CAMPAIGNS.TYPE.eq(CampaignsType.text)
                .and(CAMPAIGNS.ORDERID.gt(0L))
                .and(CAMPAIGNS.STATUSMODERATE.eq(CampaignsStatusmoderate.Yes))
                .and(CAMPAIGNS.SUM.gt(BigDecimal.ZERO))
                .and(CAMPAIGNS.ARCHIVED.eq(CampaignsArchived.No))
                .and(CAMPAIGNS.DAY_BUDGET.gt(BigDecimal.ZERO));
    }
}
