package ru.yandex.autotests.directintapi.bstransport.b2b.prepare;

import org.jooq.Condition;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusactive;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS;

@Aqua.Test
@Title("Кампании с запрещенными SSP площадками (disabled_ssp)")
@Features(FeatureNames.TRANSPORT_B2B_PREPARE)
public class CampaignsWithDisabledSSPPrepareTest extends CampaignsOnlyB2BPrepareTest {

    @Override
    protected Condition getCampaignsCondition() {
        return CAMPAIGNS.ORDERID.gt(0L)
                .and(CAMPAIGNS.TYPE.in(CampaignsType.text, CampaignsType.dynamic, CampaignsType.performance,
                        CampaignsType.mobile_content))
                .and(CAMPAIGNS.STATUSACTIVE.eq(CampaignsStatusactive.Yes))
                .and(CAMPAIGNS.ARCHIVED.eq(CampaignsArchived.No))
                .and(CAMPAIGNS.DISABLED_SSP.isNotNull())
                .and(CAMPAIGNS.DISABLED_SSP.ne("[]"));
    }
}
