package ru.yandex.autotests.directintapi.bstransport.b2b.prepare;

import java.util.List;

import org.jooq.Condition;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusarch;
import ru.yandex.autotests.direct.db.steps.base.LimitOffsetStepCallable;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BANNERS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.IMAGES;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.PHRASES;

/**
 * Created by bzzzz on 21.03.17.
 * https://st.yandex-team.ru/DIRECT-64253
 */
@Aqua.Test
@Features(FeatureNames.TRANSPORT_B2B_PREPARE)
@Title("Кампании с графическими баннерами")
public class CampaignsWithImageAdsPrepareTest extends BaseCampaignsB2BPrepareTest {

    @Override
    protected LimitOffsetStepCallable<List<Long>> getCampaignsCallable(Condition baseCondition) {
        // Order by сильно замедляет запрос, поэтому просто смотрим в последней четверти кампаний
        // Это может привести к неожиданным результатам при движении limit и offset, но мы готовы к этому
        return (db, limit, offset) -> db.selectDistinct(CAMPAIGNS.CID)
                .from(IMAGES)
                .straightJoin(BANNERS).on(BANNERS.BID.eq(IMAGES.BID))
                .join(PHRASES).on(PHRASES.PID.eq(BANNERS.PID))
                .join(CAMPAIGNS).on(CAMPAIGNS.CID.eq(PHRASES.CID))
                .where(baseCondition
                        .and(CAMPAIGNS.ORDERID.gt(0L))
                        .and(CAMPAIGNS.CID.gt(getLastProdCidDirectBalance() / 5))
                        .and(BANNERS.BANNERID.gt(0L))
                        .and(BANNERS.STATUSARCH.ne(BannersStatusarch.No)))
                .limit(offset, limit)
                .fetch(CAMPAIGNS.CID);
    }
}
