package ru.yandex.autotests.directintapi.bstransport.b2b.prepare;

import org.jooq.Condition;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusshow;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS;

/**
 * Created by buhter on 11.11.16.
 * https://st.yandex-team.ru/TESTIRT-10501
 */
@Aqua.Test
@Title("Кампании со statusShow = No")
@Features(FeatureNames.TRANSPORT_B2B_PREPARE)
public class CampaignsWithNoStatusShowPrepareTest extends CampaignsOnlyB2BPrepareTest {

    @Override
    protected Condition getCampaignsCondition() {
        return CAMPAIGNS.ORDERID.gt(0L)
                .and(CAMPAIGNS.TYPE.eq(CampaignsType.text))
                .and(CAMPAIGNS.STATUSSHOW.eq(CampaignsStatusshow.No))
                .and(CAMPAIGNS.ARCHIVED.eq(CampaignsArchived.No))
                .and(CAMPAIGNS.ORDERID.gt(0L))
                .and(CAMPAIGNS.STATUSMODERATE.eq(CampaignsStatusmoderate.Yes))
                .and(CAMPAIGNS.SUM.gt(CAMPAIGNS.SUM_SPENT));
    }
}