package ru.yandex.autotests.directintapi.bstransport.b2b.prepare.strategies;

import org.jooq.Condition;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusactive;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.b2b.prepare.CampaignsOnlyB2BPrepareTest;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS;
import static ru.yandex.autotests.direct.db.utils.MysqlDSLUtils.jsonExtract;

@Aqua.Test
@Features(FeatureNames.TRANSPORT_B2B_PREPARE)
@Title("Кампании со стратегией autobudget_avg_cpa_per_camp")
public class CampaignsWithStrategyAutoBudgetAvgCpaPerCampPrepareTest extends CampaignsOnlyB2BPrepareTest {

    @Override
    protected Condition getCampaignsCondition() {
        return CAMPAIGNS.ORDERID.gt(0L)
                .and(CAMPAIGNS.TYPE.eq(CampaignsType.performance))
                .and(CAMPAIGNS.STATUSACTIVE.eq(CampaignsStatusactive.Yes))
                .and(CAMPAIGNS.ARCHIVED.eq(CampaignsArchived.No))
                .and(CAMPAIGNS.STRATEGY_NAME.eq(CampaignsStrategyName.autobudget_avg_cpa_per_camp))
                .and(jsonExtract(CAMPAIGNS.STRATEGY_DATA, "$.sum", Double.class).gt(0d))
                .and(jsonExtract(CAMPAIGNS.STRATEGY_DATA, "$.avg_cpa", Double.class).gt(0d))
                .and(jsonExtract(CAMPAIGNS.STRATEGY_DATA, "$.avg_bid", Double.class).gt(0d));
                //не учитываем, чтобы подобрать больше кампаний
                //.and(jsonExtract(CAMPAIGNS.STRATEGY_DATA, "$.bid", Double.class).gt(0d))
                //.and(jsonExtract(CAMPAIGNS.STRATEGY_DATA, "$.goal_id", Double.class).gt(0d));
    }
}
