package ru.yandex.autotests.directintapi.bstransport.b2b.prepare.strategies;

import org.jooq.Condition;
import org.junit.Ignore;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusactive;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.b2b.prepare.CampaignsOnlyB2BPrepareTest;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS;

@Aqua.Test
@Features(FeatureNames.TRANSPORT_B2B_PREPARE)
@Title("Кампании со стратегией cpm_default")
@Ignore("пока не вышел DIRECT-69120") //не забыть добавить условия по не обязательным полям
public class CampaignsWithStrategyCmpDefaultPrepareTest extends CampaignsOnlyB2BPrepareTest {

    @Override
    protected Condition getCampaignsCondition() {
        return CAMPAIGNS.ORDERID.gt(0L)
                .and(CAMPAIGNS.TYPE.eq(CampaignsType.cpm_banner))
                .and(CAMPAIGNS.STATUSACTIVE.eq(CampaignsStatusactive.Yes))
                .and(CAMPAIGNS.ARCHIVED.eq(CampaignsArchived.No))
                .and(CAMPAIGNS.STRATEGY_NAME.eq(CampaignsStrategyName.cpm_default));
    }
}