package ru.yandex.autotests.directintapi.bstransport.b2b.prepare.strategies;

import org.jooq.Condition;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampOptionsStrategy;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusactive;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.b2b.prepare.CampaignsOnlyB2BPrepareTest;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMP_OPTIONS;

@Aqua.Test
@Title("Кампании со стратегией \"раздельное размещение\"")
@Features(FeatureNames.TRANSPORT_B2B_PREPARE)
public class CampaignsWithStrategyDifferentPlacesPreparePrepareTest extends CampaignsOnlyB2BPrepareTest {

    @Override
    protected Condition getCampaignsCondition() {
        return CAMPAIGNS.ORDERID.gt(0L)
                .and(CAMPAIGNS.TYPE.eq(CampaignsType.text))
                .and(CAMPAIGNS.STATUSACTIVE.eq(CampaignsStatusactive.Yes))
                .and(CAMPAIGNS.ARCHIVED.eq(CampaignsArchived.No))
                .and(CAMP_OPTIONS.STRATEGY.eq(CampOptionsStrategy.different_places));
    }
}
