package ru.yandex.autotests.directintapi.bstransport.b2b.utils;

import ru.yandex.autotests.irt.restheart.config.BaseMongoHelper;
import ru.yandex.autotests.irt.restheart.config.MongoDatabases;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by buhter on 11.11.16.
 * https://st.yandex-team.ru/TESTIRT-10501
 */
public class TransportB2BBeanMongoHelper extends BaseMongoHelper<TransportB2BMongoBean> {
    public static final String COLLECTION = "TransportB2BTestsCidBeans";
    public static final String QUERY = "{%s:%s}";

    public TransportB2BBeanMongoHelper() {
        super(TransportB2BMongoBean.class);
    }

    @Override
    public String getUniqueFilter(TransportB2BMongoBean transportB2BMongoBean) {
        return String.format(QUERY, TransportB2BMongoBean.CID, transportB2BMongoBean.getCid());
    }

    @Override
    public String getDb() {
        return MongoDatabases.BEAN_TEMAPLATES.getDbName();
    }

    @Override
    public String getCollection() {
        return COLLECTION;
    }

    public List<Long> getAllCids() {
        return this.getMongoBeans()
                .stream()
                .map(TransportB2BMongoBean::getCid)
                .collect(Collectors.toList());
    }

    public List<TransportB2BMongoBean> getCampaingsForTestClass(Class testClass) {
        return this.getMongoBeans(String.format(QUERY, TransportB2BMongoBean.CLASS_NAME,
                "\"" + getClassNameForBean(testClass) + "\"")
        );
    }

    public void deleteCampaignsForClass(Class testClass) {
        this.deleteMongoBean(String.format(QUERY, TransportB2BMongoBean.CLASS_NAME,
                "\"" + getClassNameForBean(testClass) + "\"")
        );
    }

    public void setLastFailedForCampaigns(boolean isLastFailed, TransportB2BMongoBean... campaigns) {
        for (TransportB2BMongoBean campaign : campaigns) {
            this.updateMongoBean(campaign.withLastFailed(isLastFailed));
        }
    }

    public static String getClassNameForBean(Class testClass) {
        return testClass.getSimpleName().replace("Prepare", "");
    }
}




