package ru.yandex.autotests.directintapi.bstransport.b2b.utils;

import com.google.gson.annotations.SerializedName;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by buhter on 11.11.16.
 */
public class TransportB2BMongoBean {
    public static final String CID = "cid";
    public static final String SHARD = "shard";
    public static final String CLASS_NAME = "className";
    public static final String IS_LAST_FAILED = "isLastFailed";

    @SerializedName(CID)
    private Long cid;

    @SerializedName(SHARD)
    private int shard;

    @SerializedName(CLASS_NAME)
    private String className;

    @SerializedName(IS_LAST_FAILED)
    private boolean isLastFailed;

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public int getShard() {
        return shard;
    }

    public void setShard(int shard) {
        this.shard = shard;
    }

    public boolean isLastFailed() {
        return isLastFailed;
    }

    public void setLastFailed(boolean lastFailed) {
        isLastFailed = lastFailed;
    }

    public TransportB2BMongoBean withCid(Long cid) {
        this.cid = cid;
        return this;
    }

    public TransportB2BMongoBean withClassName(String className) {
        this.className = className;
        return this;
    }

    public TransportB2BMongoBean withShard(int shard) {
        this.shard = shard;
        return this;
    }

    public TransportB2BMongoBean withLastFailed(boolean isLastFailed) {
        this.isLastFailed = isLastFailed;
        return this;
    }


    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
