package ru.yandex.autotests.directintapi.bstransport.b2b.utils;

import ru.yandex.autotests.direct.utils.converter.LongListConverter;
import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;
import ru.yandex.qatools.properties.annotations.Use;
import ru.yandex.qatools.properties.converters.EnumConverter;

import java.util.List;

@Resource.Classpath("transportB2B.properties")
public class TransportB2BProperties {

    public TransportB2BProperties() {
        PropertyLoader.populate(this);
    }

    /**
     * Определяет стенд, на котором запускаются тесты.
     * Для режима Beta требуется также указать ее номер
     */
    @Property("b2b.stagetype.test")
    protected String testStageType;

    /**
     * Определяет эталлоный стенд, на котором запускаются b2b тесты.
     * Для режима Beta требуется также указать ее номер
     */
    @Property("b2b.stagetype.etalon")
    protected String etalonStageType;

    /**
     * Количество кампаний, которые будут выбраны по заданным условиям/или на для которых будут произведены сравнения
     */
    @Property("b2b.campaigns.qty")
    protected Integer campaignsQuantity;

    /**
     * Непосредственно заданный список id кампаний (через запятую)
     */
    @Use(LongListConverter.class)
    @Property("b2b.campaigns.list")
    protected List<Long> campaignsList;

    /**
     * Шард, на котором будут выбираться кампании
     */
    @Property("b2b.run.failed.only")
    protected boolean failedOnly;

    /**
     * метод которым осуществляется отправка на эталонной среде.
     */
    @Property("b2b.etalon.method")
    @Use(EnumConverter.class)
    protected TransportMethodEnum etalonMethod;

    /**
     * метод которым осуществляется отправка на тестовой среде.
     */
    @Property("b2b.test.method")
    @Use(EnumConverter.class)
    protected TransportMethodEnum testMethod;

    @Property("b2b.ignore.fields.list")
    protected String b2bIgnoreFieldsList = null;

    public String getTestStageType() {
        return testStageType;
    }

    public String getEtalonStageType() {
        return etalonStageType;
    }

    public Integer getCampaignsQuantity() {
        return campaignsQuantity;
    }

    public List<Long> getCampaignsList() {
        return campaignsList;
    }

    public TransportMethodEnum getEtalonMethod() {
        return etalonMethod;
    }

    public TransportMethodEnum getTestMethod() {
        return testMethod;
    }

    public boolean isFailedOnly() {
        return failedOnly;
    }

    public String getB2bIgnoreFieldsList() {
        return b2bIgnoreFieldsList;
    }
}
