package ru.yandex.autotests.directintapi.bstransport.b2b.utils;


import java.util.Map;

import org.hamcrest.Description;

import ru.yandex.autotests.directintapi.bstransport.matchers.flags.FlagsDiffer;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.CompareStrategy;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.autotests.irt.testutils.beandiffer2.reporter.Reporter;

import static ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath.newPath;

public class UpdateDataBeanDiffer extends BeanDifferMatcher<Map> {
    public UpdateDataBeanDiffer(Map expected, BeanFieldPath... ignoredFields) {
        super(expected);
        CompareStrategy compareStrategy = DefaultCompareStrategies.allFieldsExcept(ignoredFields)
                .forFields(newPath(".+", "request", "ORDER", ".+", "CONTEXT", ".+", "BANNER", ".+", "Flags"))
                .useDiffer(new FlagsDiffer());
        useCompareStrategy(compareStrategy);
    }

    @Override
    protected void describeMismatchSafely(Map item, Description mismatchDescription) {
        Reporter reporter = new UpdateDataReporter(diffs, actual, expected);
        reporter.attachJsonDiffPatch();
        String consoleReport = reporter.attachConsoleReport();
        mismatchDescription.appendText(consoleReport);
    }
}
