package ru.yandex.autotests.directintapi.bstransport.b2b.utils;

import java.util.List;

import ru.yandex.autotests.irt.testutils.beandiffer2.Diff;
import ru.yandex.autotests.irt.testutils.beandiffer2.reporter.Reporter;
import ru.yandex.autotests.irt.testutils.beandiffer2.reporter.ReporterProperties;

public class UpdateDataReporter extends Reporter {
    public UpdateDataReporter(List<Diff> diffs, Object actualBean, Object expectedBean) {
        super(diffs, actualBean, expectedBean);
    }

    @Override
    public String attachConsoleReport() {
        if (ReporterProperties.getInstance().getDescribeFullMismatch()) {
            return "the following fields are not the same:\n" + diffs.stream()
                    .map(Object::toString)
                    .map(UpdateDataReporter::removeObjectIds)
                    .sorted()
                    .distinct()
                    .reduce((x, y) -> x + "\n" + y).orElse("");
        } else {
            Class<?> expectedType = expectedBean != null ? expectedBean.getClass() : Object.class;
            return "objects of type " + expectedType.getSimpleName() + " are different!";
        }
    }
    private static  String removeObjectIds(String path) {
        return path.replaceAll("/(ORDER|CONTEXT|BANNER)/[0-9]+", "/$1/*");
    }
}
