package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.queue;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.Status.NEW;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue " +
        "новых баннеров в составе синхронизированной с БК группы")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueNewBannerInSyncedGroupTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private Long cid;
    private Long pid;
    private Long syncedBid;
    private Long keywordId;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        syncedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(syncedBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
    }

    @Test
    @Title("Добавление в очередь нового баннера " +
            "в синхронизированной группе (без сайтлинков и визитки)")
    public void testAddingToBsQueueForAcceptedNewBannerInSyncedGroupWithNoContactsAndLinks() {
        Long newBid1 = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(newBid1);
        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord campInExportQueue =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись " +
                        "для кампании с новым принятым баннером без сайтлинков и визитки",
                campInExportQueue,
                new QueueRecordMatcher()
                        .withoutCamps()
                        .withBanners()
                        .withContexts()
                        .withBids()
                        .withoutPrices());
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);
        checkExpectations(cid, newBid1, pid, response);
    }

    @Test
    @Title("Добавление в очередь нового баннера в синхронизированной группе " +
            "(с принятыми сайтлинками и без визитки)")
    public void testAddingToBsQueueForAcceptedNewBannerInSyncedGroupWithAcceptedLinksAndNoContacts() {
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        Long newBid1 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetId)));
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(newBid1);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord campInExportQueue =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись " +
                        "для кампании с новым принятым баннером без визитки с принятыми сайтлинками",
                campInExportQueue,
                new QueueRecordMatcher()
                        .withoutCamps()
                        .withBanners()
                        .withContexts()
                        .withBids()
                        .withoutPrices());
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);
        checkExpectations(cid, newBid1, pid, response);
    }

    @Test
    @Title("Добавление в очередь нового баннера в синхронизированной группе " +
            "(с отклоненными сайтлинками и без визитки)")
    public void testAddingToBsQueueForAcceptedNewBannerInSyncedGroupWithDeclinedLinksAndNoContacts() {
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        Long newBid1 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetId)));
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(newBid1);
        api.userSteps.bannersFakeSteps().setStatusSitelinksModerate(newBid1, NO);
        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord campInExportQueue =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись " +
                        "для кампании с новым принятым баннером без визитки с отклоненными сайтлинками",
                campInExportQueue,
                new QueueRecordMatcher()
                        .withoutCamps()
                        .withBanners()
                        .withContexts()
                        .withBids()
                        .withoutPrices());
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);
        checkExpectations(cid, newBid1, pid, response);
    }

    @Test
    @Title("Добавление в очередь нескольких новых баннеров " +
            "в синхронизированной ранее группе")
    public void testAddingToBsQueueForAcceptedNewBannersInSyncedGroup() {
        Long newBid1 = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long newBid2 = api.userSteps.adsSteps().addDefaultTextAd(pid);

        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(newBid1);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(newBid2);
        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord campInExportQueue =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись " +
                        "для кампании с 2 новыми принятыми баннерами",
                campInExportQueue,
                new QueueRecordMatcher()
                        .withoutCamps()
                        .withBanners()
                        .withContexts()
                        .withBids()
                        .withoutPrices());
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);
        checkExpectations(cid, newBid1, pid, response);
        checkExpectations(cid, newBid2, pid, response);
    }

    @Test
    @Title("Добавление в очередь нескольких новых баннеров в синхронизированной группе " +
            "(присутствуют отклоненные разными способами новые баннеры)")
    public void testAddingToBsQueueForAcceptedNewBannerInSyncedGroupWithDeclinedBanners() {
        Long declainedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        Long notModeratedSitelinksBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetId)));
        Long acceptedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);

        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(declainedBid);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(declainedBid, NO);

        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(notModeratedSitelinksBid);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(notModeratedSitelinksBid, NEW);

        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(acceptedBid);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord campInExportQueue =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись для кампании с 1 новым принятым " +
                        "баннером и 2 новыми не принятыми (разными способами)",
                campInExportQueue,
                new QueueRecordMatcher()
                        .withoutCamps()
                        .withBanners()
                        .withContexts()
                        .withBids()
                        .withoutPrices());
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);
        checkExpectations(cid, acceptedBid, pid, response);
    }

    private void checkExpectations(Long cid, Long bid, Long pid, RunBsTransportScriptResponse response) {
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(response, 0,
                        cid);
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные кампании соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));

        Context context = campaign.getContext(pid);
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));

        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(keywordId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные фразы соответствуют ожидаемым",
                context.getPhrase(keywordId), beanEquals(expectedPhrase));

        Banner expectedSyncedBanner = helpSteps.buildExpectedBannerObjFromDb(syncedBid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные синхронизированного баннера соответствуют ожидаемым",
                context.getBanner(syncedBid), beanEquals(expectedSyncedBanner));

        Banner expectedNewBanner = helpSteps.buildExpectedNewBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                context.getBanner(bid), beanEquals(expectedNewBanner));
    }
}
