package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.queue;

import java.util.Map;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.YES;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue " +
        "нового отклоненного баннера в составе синхронизированной группы")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueNewBannerInSyncedGroupWithNegativeModerationTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private Long cid;
    private Long pid;
    private Long bid;
    private Long newBid;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void prepare() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        newBid = api.userSteps.adsSteps().addDefaultTextAd(pid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(newBid, YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(newBid, NO);
    }

    /*
        Здесь проверяется, что в очередь попадает группа с отклоненным новым баннером
        и отсутствием других рассинхронизированных объектов
     */
    @Test
    @Title("Добавление в очередь кампании с новым отклоненным баннером " +
            "в синхронизированной группе (статус группы statusBsSynced = No)")
    public void testAddingToBsQueueForNewBannerInSyncedGroupWithNegativeModerationWithUnsyncedGroup() {
        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord campInExportQueue =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись",
                campInExportQueue,
                new QueueRecordMatcher()
                        .withoutCamps()
                        .withBanners()
                        .withContexts()
                        .withBids()
                        .withoutPrices());
        RunBsTransportScriptResponse response =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК может быть отправлена кампания", campaign, notNullValue());
        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена группа", context, notNullValue());
        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid, bid);
        assertThat("Ожидаем, что в БК может быть отправлен принятый баннер", banner, notNullValue());
        Map newBanner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid, newBid);
        assertThat("Ожидаем, что в БК не отправлен отклоненный баннер", newBanner, nullValue());
        Map keyword = api.userSteps.transportSteps().getRawClientDataLogRequestForKeyword(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена фраза", keyword, notNullValue());


        Campaign campaignReq = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(response,
                0, cid);
        Context contextReq = campaignReq != null ? campaignReq.getContext(pid) : null;
        Banner bannerReq = context != null ? contextReq.getBanner(bid) : null;

        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                bannerReq, beanEquals(expectedBanner));
    }

    /*
        Здесь проверяется, что после того, как группа отправится без отклоненного баннера,
        новая итерация bsExportMaster не добавит отклоненный баннер в очередь
     */
    @Test
    @Title("Добавление в очередь кампании с новым отклоненным баннером " +
            "в синхронизированной группе (статус группы statusBsSynced = Yes)")
    public void testAddingToBsQueueForNewBannerInSyncedGroupWithNegativeModerationWithSyncedGroup() {
        // состояние после отправки группы после сброса ее статуса statusBsSynced (DIRECT-33440)
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.YES);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);
        assertThat("при попытке отправки в БК ничего не отправилось", response, nullValue());
    }
}
