package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.queue;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.YES;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue нового баннера " +
        "в составе синхронизированной ранее группы в зависимости от статуса модерации визитки phoneflag")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class AddingToBsQueueNewBannerInSyncedGroupWithVcardModerationTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @Parameterized.Parameter
    public String testStatus;

    @Parameterized.Parameters(name = "Статус модерации визитки phoneflag = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {Status.NEW},
                {Status.READY},
                {Status.SENT},
                {Status.SENDING},
                {Status.YES},
                {Status.NO}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    @Title("Добавление в очередь кампании с новым принятым баннером в синхронизированной ранее " +
            "группе в зависимости от статуса модерации визитки")
    public void testAddingToBsQueueForNewBannerInSyncedGroupDependingOnModerationOfVcard() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        Long newBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)));

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(newBid, YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setPhoneflag(newBid, testStatus);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(newBid, YES);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);

        BsExportQueueRecord campInExportQueue =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись " +
                        "для кампании с новым промодерированным баннером c визиткой",
                campInExportQueue,
                new QueueRecordMatcher()
                        .withoutCamps()
                        .withBanners()
                        .withContexts()
                        .withBids()
                        .withoutPrices());
    }
}
