package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.queue;

import java.sql.Timestamp;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка удаления из очереди ppc.bs_export_queue " +
        "неправильной записи для остановленного баннера")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class RemovingFromBsQueueInvalidEntryForStoppedBannerTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    @Title("Удаление из очереди неправильной записи для остановленного нового баннера " +
            "в синхронизированной кампании")
    public void testRemovingFromBsQueueInvalidEntryForStoppedBanner() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long stoppedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(stoppedBid);
        api.userSteps.adsSteps().adsSuspend(stoppedBid);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        // создаем запись для остановленного баннера (на самом деле остановленные баннеры не отправляем)
        BsExportQueueRecord campInExportQueue = new BsExportQueueRecord()
                .setCid(cid)
                .setQueueTime(Timestamp.valueOf("2015-02-24 14:20:56.0"))
                .setSeqTime(Timestamp.valueOf("2015-02-24 14:20:56.0"))
                .setSyncVal(0L)
                .setCampsNum(0L)
                .setBannersNum(1L)
                .setContextsNum(1L)
                .setBidsNum(1L)
                .setPricesNum(0L)
                .setIsFullExport(0);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .transportSteps()
                .createBsExportQueueRecord(campInExportQueue);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .runBsClientDataScript(shard, cid);
        if (resp != null) {
            List<Campaign> campaignAllRequests = api.userSteps.getDarkSideSteps().getTransportSteps()
                    .getClientDataRequestCampaignAllIterations(resp, cid);
            assumeThat("кампания не отправлена в БК", campaignAllRequests, empty());
        }

        BsExportQueueRecord entryAfterWorkerRun = api.userSteps.getDirectJooqDbSteps().transportSteps()
                .getBsExportQueueRecord(cid);
        assertThat("из таблицы удалена неправильная запись для нового остановленного баннера",
                entryAfterWorkerRun, nullValue());
    }
}
