package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.receive;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка изменений после успешной отправки " +
        "нового баннера в новой кампании")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsResponseHandlingForNewBannerInNewCampaignTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private static Long bid;
    private static Long pid;

    private static Banner banner;


    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);


        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
    }

    // кампания проверяется в тестах кампаний для аналогичного кейса
    // фраза проверяется в тестах фраз для аналогичного кейса

    @Test
    @Title("Изменения после успешной отправки нового баннера в новой кампании - " +
            "статус statusBsSynced Группы")
    public void testGroupSyncStatusAfterTransmissionOfNewBannerInNewCampaign() {
        PhrasesRecord phrasesRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().getPhrases(pid);
        assertThat("после синхронизации группы statusBsSynced = Yes",
                phrasesRecord.getStatusbssynced(), equalTo(PhrasesStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после успешной отправки нового баннера в новой кампании - " +
            "статус statusBsSynced Баннера")
    public void testBannerSyncStatusAfterTransmissionOfNewBannerInNewCampaign() {
        BannersRecord bannerDb = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid);
        assertThat("после синхронизации баннера statusBsSynced = Yes",
                bannerDb.getStatusbssynced(), equalTo(BannersStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после успешной отправки нового баннера в новой кампании - " +
            "BannerID Баннера")
    public void testBannerIdAfterTransmissionOfNewBannerInNewCampaign() {
        String bannerId = banner.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        Long dbBannerId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid).getBannerid();
        assertThat("правильный BannerID у баннера после синхронизации",
                dbBannerId, equalTo(Long.valueOf(banner.getId())));
    }
}
