package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.receive;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка изменений после успешной отправки " +
        "нового баннера в синхронизированной кампании")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsResponseHandlingForNewBannerInSyncedCampaignTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private static Long cid;
    private static Long pid;
    private static Long syncedBid;
    private static Long newBid;

    private static Banner newBanner;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        syncedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(syncedBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        newBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(newBid);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        newBanner = context != null ? context.getBanner(newBid) : null;
    }

    @Test
    @Title("Изменения после успешной отправки нового баннера в синхронизированной кампании - " +
            "статус statusBsSynced Кампании")
    public void testCampaignSyncStatusAfterTransmissionOfNewBannerInSyncedCampaign() {
        CampaignsRecord campDb = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid);
        assertThat("у синхронизированной кампании statusBsSynced = Yes",
                campDb.getStatusbssynced(), equalTo(CampaignsStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после успешной отправки нового баннера в синхронизированной кампании - " +
            "статус statusBsSynced Группы")
    public void testGroupSyncStatusAfterTransmissionOfNewBannerInSyncedCampaign() {
        PhrasesRecord groupDb = api.userSteps.getDirectJooqDbSteps().adGroupsSteps().getPhrases(pid);
        assertThat("после синхронизации группы statusBsSynced = Yes",
                groupDb.getStatusbssynced(), equalTo(PhrasesStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после успешной отправки нового баннера в синхронизированной кампании - " +
            "статус statusBsSynced Баннера (синхронизированного)")
    public void testSyncedBannerSyncStatusAfterTransmissionOfNewBannerInSyncedCampaign() {
        BannersRecord syncedBannerDb =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(syncedBid);
        assertThat("у синхронизированного баннера statusBsSynced = Yes",
                syncedBannerDb.getStatusbssynced(), equalTo(BannersStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после успешной отправки нового баннера в синхронизированной кампании - " +
            "статус statusBsSynced Баннера (нового)")
    public void testNewBannerSyncStatusAfterTransmissionOfNewBannerInSyncedCampaign() {
        BannersRecord newBannerDb =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(newBid);
        assertThat("после синхронизации баннера statusBsSynced = Yes",
                newBannerDb.getStatusbssynced(), equalTo(BannersStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после успешной отправки нового баннера в синхронизированной кампании - " +
            "BannerID Баннера (нового)")
    public void testBannerIdAfterTransmissionOfNewBannerInSyncedCampaign() {
        String bannerId = newBanner.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        Long dbBannerId = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(newBid)
                .getBannerid();
        assertThat("правильный BannerID у баннера после синхронизации",
                dbBannerId, equalTo(Long.valueOf(newBanner.getId())));
    }
}
