package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.receive;

import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка изменений после успешной отправки " +
        "новых баннеров, фраз и ретаргетингов в составе новой группы (2)")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsResponseHandlingForNewBannersInNewGroupTest2
        extends BsResponseHandlingForNewBannersInNewGroupBaseTest
{
    @Test
    @Title("Изменения после успешной отправки кампании с новыми баннерами, фразами и ретаргетингами " +
            "в новой группе (кампания так же новая) - статус statusBsSynced Баннера 1")
    public void testBanner1SyncStatusAfterTransmissionForNewBannersAndPhrasesAndRetargetingsInNewGroup() {
        BannersRecord bannerDb1 = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid1);
        assertThat("после синхронизации баннера statusBsSynced = Yes",
                bannerDb1.getStatusbssynced(), equalTo(BannersStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после успешной отправки кампании с новыми баннерами, фразами и ретаргетингами " +
            "в новой группе (кампания так же новая) - статус statusBsSynced Баннера 2")
    public void testBanner2SyncStatusAfterTransmissionForNewBannersAndPhrasesAndRetargetingsInNewGroup() {
        BannersRecord bannerDb2 = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid2);
        assertThat("после синхронизации баннера statusBsSynced = Yes",
                bannerDb2.getStatusbssynced(), equalTo(BannersStatusbssynced.Yes));
    }
}
