package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.receive;

import java.math.BigInteger;

import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка изменений после успешной отправки " +
        "новых баннеров, фраз и ретаргетингов в составе новой группы (3)")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsResponseHandlingForNewBannersInNewGroupTest3
        extends BsResponseHandlingForNewBannersInNewGroupBaseTest {

    @Test
    @Title("Изменения после успешной отправки кампании с новыми баннерами, фразами и ретаргетингами " +
            "в новой группе (кампания так же новая) - OrderID Кампании")
    public void testOrderIdAfterTransmissionForNewBannersAndPhrasesAndRetargetingsInNewGroup() {
        CampaignsRecord dbCampaign =  api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid);
        assertThat("правильный OrderID у кампании после синхронизации",
                dbCampaign.getOrderid(), equalTo(Long.valueOf(campaign.getId())));
    }

    @Test
    @Title("Изменения после успешной отправки кампании с новыми баннерами, фразами и ретаргетингами " +
            "в новой группе (кампания так же новая) - PhraseID Фразы 1")
    public void testPhrase1IdAfterTransmissionForNewBannersAndPhrasesAndRetargetingsInNewGroup() {
        BidsRecord phraseDb1 = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsSteps().getBidById(bidsId1);
        assertThat("правильный PhraseID у фразы после синхронизации",
                phraseDb1.getPhraseid(), equalTo(new BigInteger(phrase1.getId())));
    }

    @Test
    @Title("Изменения после успешной отправки кампании с новыми баннерами, фразами и ретаргетингами " +
            "в новой группе (кампания так же новая) - PhraseID Фразы 2")
    public void testPhrase2IdAfterTransmissionForNewBannersAndPhrasesAndRetargetingsInNewGroup() {
        //Bids phraseDb2 = api.userSteps.getDBSteps().getBidsSteps().getBids(bidsId2, shard);
        BidsRecord phraseDb2 = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsSteps().getBidById(bidsId2);
        assertThat("правильный PhraseID у фразы после синхронизации",
                phraseDb2.getPhraseid(), equalTo(new BigInteger(phrase2.getId())));
    }

    @Test
    @Title("Изменения после успешной отправки кампании с новыми баннерами, фразами и ретаргетингами " +
            "в новой группе (кампания так же новая) - BannerID Баннера 1")
    public void testBanner1IdAfterTransmissionForNewBannersAndPhrasesAndRetargetingsInNewGroup() {
        BannersRecord dbBanner = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid1);
        assertThat("правильный BannerID у баннера после синхронизации",
                dbBanner.getBannerid(), equalTo(Long.valueOf(banner1.getId())));
    }

    @Test
    @Title("Изменения после успешной отправки кампании с новыми баннерами, фразами и ретаргетингами " +
            "в новой группе (кампания так же новая) - BannerID Баннера 2")
    public void testBanner2IdAfterTransmissionForNewBannersAndPhrasesAndRetargetingsInNewGroup() {
        BannersRecord dbBanner = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid2);
        assertThat("правильный BannerID у баннера после синхронизации",
                dbBanner.getBannerid(), equalTo(Long.valueOf(banner2.getId())));
    }
}
