package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.receive;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class BsResponseHandlingForNewBannersInSyncedGroupBaseTest {

    protected static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    protected static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    protected static int shard;

    protected static Long cid;
    protected static Long pid;
    protected static Long bidsId1;
    protected static Long bidsId2;
    protected static Long retId1;
    protected static Long retId2;
    protected static Long bid1;
    protected static Long bid2;

    protected static Campaign campaign;
    protected static Phrase phrase1;
    protected static Phrase phrase2;
    protected static Banner banner1;
    protected static Banner banner2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);

        List<Long> retCondIds = helpSteps.addRetargetingListsForUserIfNotExists(login);
        Long retCondId1 = retCondIds.get(0);
        Long retCondId2 = retCondIds.get(1);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long syncedBidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(syncedBidsId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(3);

        bid1 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)
                        .withSitelinkSetId(sitelinkSetId)));
        bid2 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)
                        .withSitelinkSetId(sitelinkSetId)));

        retId1 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(login, pid, retCondId1);
        retId2 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(login, pid, retCondId2);

        bidsId1 = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        bidsId2 = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(bid1);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(bid2);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId1);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId2);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        phrase1 = context != null ? context.getPhrase(bidsId1) : null;
        phrase2 = context != null ? context.getPhrase(bidsId2) : null;
        banner1 = context != null ? context.getBanner(bid1) : null;
        banner2 = context != null ? context.getBanner(bid2) : null;

        assumeThat("в ответе БК присутствует кампания", campaign, notNullValue());
        assumeThat("в ответе БК присутствует контекст", context, notNullValue());
        assumeThat("в ответе БК присутствует фраза", phrase1, notNullValue());
        assumeThat("в ответе БК присутствует фраза", phrase2, notNullValue());
        assumeThat("в ответе БК присутствует баннер", banner1, notNullValue());
        assumeThat("в ответе БК присутствует баннер", banner2, notNullValue());
    }
}
