package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.receive;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.qatools.Tag;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;

import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка изменений после успешной отправки " +
        "новых баннеров, фраз и ретаргетингов в составе синхронизированной группы (1)")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsResponseHandlingForNewBannersInSyncedGroupTest1
        extends BsResponseHandlingForNewBannersInSyncedGroupBaseTest {

    @Test
    @Title("Изменения после успешной отправки кампании с новыми баннерами, фразами и ретаргетингами " +
            "в синхронизированной ранее группе - статус statusBsSynced Кампании")
    public void testCampaignSyncStatusAfterTransmissionForNewBannersAndPhrasesAndRetargetingsInSyncedGroup() {
        CampaignsRecord campaignDb = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid);
        assertThat("после синхронизации статус кампании statusBsSynced = Yes",
                campaignDb.getStatusbssynced(), equalTo(CampaignsStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после успешной отправки кампании с новыми баннерами, фразами и ретаргетингами " +
            "в синхронизированной ранее группе - статус statusBsSynced Группы")
    public void testGroupSyncStatusAfterTransmissionForNewBannersAndPhrasesAndRetargetingsInSyncedGroup() {
        PhrasesRecord groupDb = api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().getPhrases(pid);
        assertThat("после синхронизации группы statusBsSynced = Yes",
                groupDb.getStatusbssynced(), equalTo(PhrasesStatusbssynced.Yes));
    }
}
