package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.transmit.moderation;

import java.util.Map;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ContactInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasKey;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.Status.YES;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/*
    Здесь проверяем, что с любым отрицательным статусом модерации визитки
    баннер отправляется, но без нее, и без пермалинка
 */
public class BsTransportOfNewBannerInNewGroupWithNotAcceptedContactsAndNoLinksBaseTest {

    protected static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    protected static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    protected static int shard;

    @Parameterized.Parameter
    public String testStatus;

    protected Long bid;
    protected Long pid;

    protected Campaign campaign;
    protected Context context;
    protected Banner banner;
    protected ContactInfo contactInfo;
    private static Map<String, Map> rawBannerRequest;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Before
    public void prepare() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)));
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(bid, YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setPhoneflag(bid, testStatus);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid, YES);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        contactInfo = banner != null ? banner.getContactInfo() : null;
        rawBannerRequest = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getRawClientDataLogRequestForBanner(resp, cid, pid, bid);
    }

    @Test
    @Title("Отправка в БК кампании с новым баннером в новой группе (кампания так же новая) " +
            "(с не принятой визиткой и без сайтлинков) - проверка объекта Контекст")
    public void testTransportOfContextObjForNewBannerInNewGroupWithNotAcceptedContactsAndNoLinks() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с новым баннером в новой группе (кампания так же новая) " +
            "(с не принятой визиткой и без сайтлинков) - проверка объекта Баннер")
    public void testTransportOfBannerObjForNewBannerInNewGroupWithNotAcceptedContactsAndNoLinks() {
        Banner expectedBanner = helpSteps.buildExpectedNewBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК кампании с новым баннером в новой группе (кампания так же новая) " +
            "(с не принятой визиткой и без сайтлинков) - проверка отсутствия Визитки")
    public void testTransportOfVcardObjForNewBannerInNewGroupWithNotAcceptedContactsAndNoLinks() {
        assertThat("визитка не отправлена в БК", contactInfo, nullValue());
    }

}
