package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.transmit.moderation;

import java.util.List;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.Status.NEW;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нового баннера " +
        "в составе синхронизированной группы с отклоненными баннерами")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewBannerInSyncedGroupWithDeclinedBannersTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long bid;
    private static Long acceptedBid;
    private static Long pid;

    private static Context context;
    private static List<Banner> bannerList;
    private static Banner syncedBanner;
    private static Banner newBanner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(3);
        Long declinedBid1 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetId)));
        Long declinedBid2 = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long sitelinkSetIdElse = api.userSteps.sitelinksSteps().addDefaultSet(3);
        acceptedBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetIdElse)));

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(declinedBid1);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusSitelinksModerate(declinedBid1, NEW);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(declinedBid2);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(declinedBid2, NO);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(acceptedBid);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        Map<String, Banner> banners = context != null ? context.getBanners() : null;
        bannerList = getMapValues(banners);
        syncedBanner = context != null ? context.getBanner(bid) : null;
        newBanner = context != null ? context.getBanner(acceptedBid) : null;
    }

    @Test
    @Title("Отправка в БК кампании с новым баннером в синхронизированной ранее группе " +
            "(присутствуют отклоненные баннеры) - проверка объекта Контекст")
    public void testTransportOfContextObjForNewBannerInSyncedGroupWithDeclinedBanners() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с новым баннером в синхронизированной ранее группе " +
            "(присутствуют отклоненные баннеры) - проверка списка Баннеров")
    public void testTransportOfBannerListForNewBannerInSyncedGroupWithDeclinedBanners() {
        assertThat("размер отправленного в БК списка баннеров соответствует ожидаемому",
                bannerList, hasSize(2));
    }

    @Test
    @Title("Отправка в БК кампании с новым баннером в синхронизированной ранее группе " +
            "(присутствуют отклоненные баннеры) - проверка объекта Баннер (синхронизированный ранее)")
    public void testTransportOfSyncedBannerObjForNewBannerInSyncedGroupWithDeclinedBanners() {
        Banner expectedSyncedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные синхронизированного баннера соответствуют ожидаемым",
                syncedBanner, beanEquals(expectedSyncedBanner));
    }

    @Test
    @Title("Отправка в БК кампании с новым баннером в синхронизированной ранее группе " +
            "(присутствуют отклоненные баннеры) - проверка объекта Баннер (новый)")
    public void testTransportForNewBannerInSyncedGroupWithDeclinedBannersOfNewBannerObj() {
        Banner expectedNewBanner = helpSteps.buildExpectedNewBannerObjFromDb(acceptedBid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                newBanner, beanEquals(expectedNewBanner));
    }
}
