package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.transmit.moderation;

import java.util.List;
import java.util.Map;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.YES;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class BsTransportOfNewBannerInSyncedGroupWithNegativeModerationBaseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    @Parameterized.Parameter
    public String testStatus;

    private Long bid;
    private Long pid;

    private Context context;
    private Banner syncedBanner;
    private List<Banner> bannerList;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
    }

    @Before
    public void prepare() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long newBid = api.userSteps.adsSteps().addDefaultTextAd(pid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(newBid, YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(newBid, testStatus);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        Map<String, Banner> banners = context != null ? context.getBanners() : null;
        bannerList = getMapValues(banners);
        syncedBanner = context != null ? context.getBanner(bid) : null;
    }

    @Test
    @Title("Не-отправка в БК не принятого нового баннера в синхронизированной группе - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjForNewBannerInSyncedGroupWithNegativeModeration() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Не-отправка в БК не принятого нового баннера в синхронизированной группе - " +
            "проверка количества Баннеров (что отправлен только синхронизированный баннер)")
    public void testTransportOfBannerListForNewBannerInSyncedGroupWithNegativeModeration() {
        assertThat("в БК отправлен список баннеров правильного размера",
                bannerList, hasSize(1));
    }

    @Test
    @Title("Не-отправка в БК не принятого нового баннера в синхронизированной группе - " +
            "проверка объекта Баннер (синхронизированный ранее)")
    public void testTransportOfSyncedBannerObjForNewBannerInSyncedGroupWithNegativeModeration() {
        Banner expectedSyncedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные синхронизированного баннера соответствуют ожидаемым",
                syncedBanner, beanEquals(expectedSyncedBanner));
    }
}
