package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.transmit.moderation;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ContactInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Sitelink;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нескольких новых баннеров " +
        "с сайтлинками и визиткой в составе новой группы")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewBannersInNewGroupWithContactsAndLinksTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long bid1;
    private static Long bid2;
    private static Long pid;

    private static Context context;
    private static Banner banner1;
    private static Banner banner2;
    private static ContactInfo contactInfo1;
    private static ContactInfo contactInfo2;
    private static List<Sitelink> sitelinks1;
    private static List<Sitelink> sitelinks2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(3);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        bid1 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetId)
                        .withVCardId(vCardId)));
        bid2 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetId)
                        .withVCardId(vCardId)));
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid1);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid2);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner1 = context != null ? context.getBanner(bid1) : null;
        banner2 = context != null ? context.getBanner(bid2) : null;
        contactInfo1 = banner1 != null ? banner1.getContactInfo() : null;
        contactInfo2 = banner2 != null ? banner2.getContactInfo() : null;
        sitelinks1 = banner1 != null ? banner1.getSitelinks() : null;
        sitelinks2 = banner2 != null ? banner2.getSitelinks() : null;
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в новой группе (кампания так же новая) " +
            "(с принятыми визиткой и сайтлинками) - проверка объекта Контекст")
    public void testTransportOfContextObjForNewBannersInNewGroupWithContactsAndLinks() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в новой группе (кампания так же новая) " +
            "(с принятыми визиткой и сайтлинками) - проверка объекта Баннер 1")
    public void testTransportOfBanner1ObjForNewBannersInNewGroupWithContactsAndLinks() {
        Banner expectedBanner1 = helpSteps.buildExpectedNewBannerObjFromDb(bid1, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner1, beanEquals(expectedBanner1));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в новой группе (кампания так же новая) " +
            "(с принятыми визиткой и сайтлинками) - проверка объекта Баннер 2")
    public void testTransportOfBanner2ObjForNewBannersInNewGroupWithContactsAndLinks() {
        Banner expectedBanner2 = helpSteps.buildExpectedNewBannerObjFromDb(bid2, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner2, beanEquals(expectedBanner2));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в новой группе (кампания так же новая) " +
            "(с принятыми визиткой и сайтлинками) - проверка наличия Визитки в Баннере 1")
    public void testTransportOfVcard1ObjForNewBannersInNewGroupWithContactsAndLinks() {
        assertThat("в БК отправлена визитка", contactInfo1, notNullValue());
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в новой группе (кампания так же новая) " +
            "(с принятыми визиткой и сайтлинками) - проверка наличия Визитки в Баннере 2")
    public void testTransportOfVcard2ObjForNewBannersInNewGroupWithContactsAndLinks() {
        assertThat("в БК отправлена визитка", contactInfo2, notNullValue());
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в новой группе (кампания так же новая) " +
            "(с принятыми визиткой и сайтлинками) - проверка наличия Сайтлинков в Баннере 1")
    public void testTransportOfSitelinks1ObjForNewBannersInNewGroupWithContactsAndLinks() {
        assertThat("сайтлинки отправлены в БК", sitelinks1, hasSize(3));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в новой группе (кампания так же новая) " +
            "(с принятыми визиткой и сайтлинками) - проверка наличия Сайтлинков в Баннере 2")
    public void testTransportOfSitelinks2ObjForNewBannersInNewGroupWithContactsAndLinks() {
        assertThat("сайтлинки отправлены в БК", sitelinks2, hasSize(3));
    }
}
