package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.transmit.moderation;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ContactInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Sitelink;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.darkside.model.Status.NO;

public class BsTransportOfNewBannersInSyncedGroupWithContactsAndLinksBaseTest {

    protected static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    protected static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    protected static int shard;

    protected static Long cid;
    protected static Long bid;
    protected static Long newBid1;
    protected static Long newBid2;
    protected static Long pid;

    protected static Context context;
    protected static Banner syncedBanner;
    protected static Banner newBanner1;
    protected static Banner newBanner2;
    protected static ContactInfo newContactInfo1;
    protected static ContactInfo newContactInfo2;
    protected static List<Sitelink> newSitelinks1;
    protected static List<Sitelink> newSitelinks2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        Long sitelingSetId = api.userSteps.sitelinksSteps().addDefaultSet(3);
        newBid1 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)
                        .withSitelinkSetId(sitelingSetId)));
        newBid2 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)
                        .withSitelinkSetId(sitelingSetId)));

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(newBid1);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(newBid2);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        syncedBanner = context != null ? context.getBanner(bid) : null;
        newBanner1 = context != null ? context.getBanner(newBid1) : null;
        newBanner2 = context != null ? context.getBanner(newBid2) : null;
        newContactInfo1 = newBanner1 != null ? newBanner1.getContactInfo() : null;
        newContactInfo2 = newBanner2 != null ? newBanner2.getContactInfo() : null;
        newSitelinks1 = newBanner1 != null ? newBanner1.getSitelinks() : null;
        newSitelinks2 = newBanner2 != null ? newBanner2.getSitelinks() : null;
    }

}
