package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.transmit.moderation;
import ru.yandex.qatools.Tag;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;

import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нескольких новых баннеров " +
        "в составе синхронизированной группы (1)")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewBannersInSyncedGroupWithContactsAndLinksTest1
        extends BsTransportOfNewBannersInSyncedGroupWithContactsAndLinksBaseTest {

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в синхронизированной ранее группе " +
            "(с принятыми визиткой и сайтлинками) - проверка объекта Контекст")
    public void testTransportOfContextObjForNewBannersInSyncedGroupWithContactsAndLinks() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в синхронизированной ранее группе " +
            "(с принятыми визиткой и сайтлинками) - проверка объекта Баннер (синхронизированный ранее)")
    public void testTransportOfSyncedBannerObjForNewBannersInSyncedGroupWithContactsAndLinks() {
        Banner expectedSyncedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные синхронизированного баннера соответствуют ожидаемым",
                syncedBanner, beanEquals(expectedSyncedBanner));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в синхронизированной ранее группе " +
            "(с принятыми визиткой и сайтлинками) - проверка объекта Баннер 1 (новый))")
    public void testTransportOfNewBanner1ObjForNewBannersInSyncedGroupWithContactsAndLinks() {
        Banner expectedNewBanner1 = helpSteps.buildExpectedNewBannerObjFromDb(newBid1, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                newBanner1, beanEquals(expectedNewBanner1));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в синхронизированной ранее группе " +
            "(с принятыми визиткой и сайтлинками) - проверка объекта Баннер 2 (новый))")
    public void testTransportOfNewBanner2ObjForNewBannersInSyncedGroupWithContactsAndLinks() {
        Banner expectedNewBanner2 = helpSteps.buildExpectedNewBannerObjFromDb(newBid2, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                newBanner2, beanEquals(expectedNewBanner2));
    }
}
