package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.creation.transmit.moderation;
import ru.yandex.qatools.Tag;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;

import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нескольких новых баннеров " +
        "в составе синхронизированной группы (2)")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewBannersInSyncedGroupWithContactsAndLinksTest2
        extends BsTransportOfNewBannersInSyncedGroupWithContactsAndLinksBaseTest {

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в синхронизированной ранее группе " +
            "(с принятыми визиткой и сайтлинками) - проверка наличия Визитки в Баннере 1 (новом)")
    public void testTransportOfNewVcard1ObjForNewBannersInSyncedGroupWithContactsAndLinks() {
        assertThat("визитка нового баннера отправлена в БК",
                newContactInfo1, notNullValue());
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в синхронизированной ранее группе " +
            "(с принятыми визиткой и сайтлинками) - проверка наличия Визитки в Баннере 2 (новом)")
    public void testTransportOfNewVcard2ObjForNewBannersInSyncedGroupWithContactsAndLinks() {
        assertThat("визитка нового баннера отправлена в БК",
                newContactInfo2, notNullValue());
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в синхронизированной ранее группе " +
            "(с принятыми визиткой и сайтлинками) - проверка наличия Сайтлинков в Баннере 1 (новом)")
    public void testTransportOfNewSitelinks1ObjForNewBannersInSyncedGroupWithContactsAndLinks() {
        assertThat("сайтлинки нового баннера отправлены в БК",
                newSitelinks1, hasSize(3));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими новыми баннерами в синхронизированной ранее группе " +
            "(с принятыми визиткой и сайтлинками) - проверка наличия Сайтлинков в Баннере 2 (новом)")
    public void testTransportOfNewSitelinks2ObjForNewBannersInSyncedGroupWithContactsAndLinks() {
        assertThat("сайтлинки нового баннера отправлены в БК",
                newSitelinks2, hasSize(3));
    }
}
