package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.rejecting.transmit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.REJECTED;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК " +
        "отклоненного (rejected) баннера и синхронизированного")
@Stories(StoriesNames.BANNER_ACTION_REJECTING)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfRejectedBannerAndSyncedBannerTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long syncedBid;
    private static Long rejectedBid;
    private static Long pid;

    private static Context context;
    private static Banner rejectedBanner;
    private static Banner syncedBanner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        rejectedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        syncedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(rejectedBid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(syncedBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusBsSynced(rejectedBid, NO);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(rejectedBid, NO);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(rejectedBid, REJECTED);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        rejectedBanner = context != null ? context.getBanner(rejectedBid) : null;
        syncedBanner = context != null ? context.getBanner(syncedBid) : null;
    }

    @Test
    @Title("Отправка в БК кампании с отклоненным баннером и синхронизированным - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjForRejectedBannerAndSyncedBanner() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с отклоненным баннером и синхронизированным - " +
            "проверка объекта Баннер (отклоненный)")
    public void testTransportOfRejectedBannerObjForRejectedBannerAndSyncedBanner() {
        Banner expectedRejectedBanner = helpSteps.buildExpectedBannerObjFromDb(rejectedBid, shard, UpdateInfo.SKIP);
        expectedRejectedBanner.setStop(StopFlag.STOP.value());
        assertThat("отправленные в БК данные отклоненного баннера соответствуют ожидаемым",
                rejectedBanner, beanEquals(expectedRejectedBanner));
    }

    @Test
    @Title("Отправка в БК кампании с отклоненным баннером и синхронизированным - " +
            "проверка объекта Баннер (синхронизированный)")
    public void testTransportOfAcceptedBannerObjForRejectedBannerAndSyncedBanner() {
        Banner expectedSyncedBanner = helpSteps.buildExpectedBannerObjFromDb(syncedBid, shard, UpdateInfo.SKIP);
        expectedSyncedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные синхронизированного баннера соответствуют ожидаемым",
                syncedBanner, beanEquals(expectedSyncedBanner));
    }
}
