package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.rejecting.transmit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.REJECTED;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК " +
        "нескольких отклоненных (rejected) баннеров")
@Stories(StoriesNames.BANNER_ACTION_REJECTING)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfRejectedBannersTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long bid1;
    private static Long bid2;
    private static Long pid;

    private static Context context;
    private static Banner rejectedBanner1;
    private static Banner rejectedBanner2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid1 = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bid2 = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid1);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid2);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusBsSynced(bid1, NO);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(bid1, NO);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid1, REJECTED);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusBsSynced(bid2, NO);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(bid2, NO);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid2, REJECTED);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        rejectedBanner1 = context != null ? context.getBanner(bid1) : null;
        rejectedBanner2 = context != null ? context.getBanner(bid2) : null;
    }

    @Test
    @Title("Отправка в БК кампании с несколькими отклоненными баннерами - проверка объекта Контекст")
    public void testTransportOfContextObjForRejectedBanners() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими отклоненными баннерами - проверка объекта Баннер (1)")
    public void testTransportOfBannerObj2ForRejectedBanners() {
        Banner expectedRejectedBanner1 = helpSteps.buildExpectedBannerObjFromDb(bid1, shard, UpdateInfo.SKIP);
        expectedRejectedBanner1.setStop(StopFlag.STOP.value());
        assertThat("отправленные в БК данные отклоненного баннера соответствуют ожидаемым",
                rejectedBanner1, beanEquals(expectedRejectedBanner1));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими отклоненными баннерами - проверка объекта Баннер (2)")
    public void testTransportOfBannerObj1ForRejectedBanners() {
        Banner expectedRejectedBanner2 = helpSteps.buildExpectedBannerObjFromDb(bid2, shard, UpdateInfo.SKIP);
        expectedRejectedBanner2.setStop(StopFlag.STOP.value());
        assertThat("отправленные в БК данные отклоненного баннера соответствуют ожидаемым",
                rejectedBanner2, beanEquals(expectedRejectedBanner2));
    }
}
