package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.resuming.transmit;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нескольких запущенных баннеров")
@Stories(StoriesNames.BANNER_ACTION_RESUMING)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfResumedBannersTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long bid1;
    private static Long bid2;
    private static Long pid;

    private static Context context;
    private static Map<String, Phrase> phrases;
    private static Banner banner1;
    private static Banner banner2;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid1 = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bid2 = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid1);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid2);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.adsSteps().adsSuspend(bid1);
        api.userSteps.adsSteps().adsSuspend(bid2);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);

        api.userSteps.adsSteps().adsResume(bid1);
        api.userSteps.adsSteps().adsResume(bid2);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        phrases = context != null && context.getPhrases() != null && context.getPhrases().size() > 0 ?
                context.getPhrases() : null;
        banner1 = context != null ? context.getBanner(bid1) : null;
        banner2 = context != null ? context.getBanner(bid2) : null;
    }

    @Test
    @Title("Отправка в БК кампании с несколькими запущенными баннерами " +
            "- проверка объекта Контекст")
    public void testTransportOfContextObjForResumedBanners() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные группы с запущенными баннерами соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими запущенными баннерами " +
            "- проверка списка Фраз")
    public void testTransportOfPhraseListForResumedBanners() {
        assertThat("вместе с кампанией с запущенными баннерами не отправлены фразы",
                phrases, nullValue());
    }

    @Test
    @Title("Отправка в БК кампании с несколькими запущенными баннерами " +
            "- проверка объекта Баннер (1)")
    public void testTransportOfBannerObj1ForResumedBanners() {
        Banner expectedBanner1 = helpSteps.buildExpectedBannerObjFromDb(bid1, shard, UpdateInfo.UPDATE);
        expectedBanner1.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные запущенного баннера соответствуют ожидаемым",
                banner1, beanEquals(expectedBanner1));
    }

    @Test
    @Title("Отправка в БК кампании с несколькими запущенными баннерами " +
            "- проверка объекта Баннер (2)")
    public void testTransportOfBannerObj2ForResumedBanners() {
        Banner expectedBanner2 = helpSteps.buildExpectedBannerObjFromDb(bid2, shard, UpdateInfo.UPDATE);
        expectedBanner2.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные запущенного баннера соответствуют ожидаемым",
                banner2, beanEquals(expectedBanner2));
    }
}
