package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.resuming.transmit;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК запущенного баннера с картинкой")
@Stories(StoriesNames.BANNER_ACTION_RESUMING)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfResumedPicBannerTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long pid;
    private static Long resumedBid;
    private static Long resumedImageId;

    private static Campaign campaign;
    private static Context context;
    private static Map<String, Phrase> phrases;
    private static Banner resumedBanner;
    private static Banner resumedPic;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, REGULAR);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        resumedBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdImageHash(imageHashes[0])));
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(resumedBid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        resumedImageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(resumedBid).getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setBannerImagesStatusModerate(resumedImageId, BannerImagesStatusmoderate.Yes);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.adsSteps().adsSuspend(resumedBid);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);

        api.userSteps.adsSteps().adsResume(resumedBid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        phrases = context != null && context.getPhrases() != null && context.getPhrases().size() > 0 ?
                context.getPhrases() : null;
        resumedBanner = context != null ? context.getBanner(resumedBid) : null;
        resumedPic = context != null ? context.getBanner(resumedImageId) : null;
    }

    @Test
    @Title("Отправка в БК кампании с запущенным баннером с картинкой - проверка объекта Кампания")
    public void testTransportOfCampaignObjForResumedPicBanner() {
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.SKIP);
        expectedCampaign.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные кампании с запущенным баннером соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК кампании с запущенным баннером с картинкой - проверка объекта Контекст")
    public void testTransportOfContextObjForResumedPicBanner() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные группы с запущенным баннером соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с запущенным баннером с картинкой - проверка списка Фраз")
    public void testTransportOfPhraseListForResumedPicBanner() {
        assertThat("вместе с кампанией с запущенным баннером не отправлены фразы",
                phrases, nullValue());
    }

    @Test
    @Title("Отправка в БК кампании с запущенным баннером с картинкой - проверка объекта Баннер")
    public void testTransportOfBannerObjForResumedPicBanner() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(resumedBid, shard, UpdateInfo.UPDATE);
        expectedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные запущенного баннера соответствуют ожидаемым",
                resumedBanner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК кампании с запущенным баннером с картинкой - проверка объекта Картинка")
    public void testTransportOfPicObjForResumedPicBanner() {
        Banner expectedStoppedPic =
                helpSteps.buildExpectedPicBannerObjFromDb(resumedImageId, shard, UpdateInfo.UPDATE);
        expectedStoppedPic.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные остановленной картинки соответствуют ожидаемым",
                resumedPic, beanEquals(expectedStoppedPic));
    }
}
