package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.stopping.transmit;

import java.util.Map;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК остановленного " +
        "баннера и отредактированного баннера")
@Stories(StoriesNames.BANNER_ACTION_STOPPING)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfStoppedBannerAndEditedBannerTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long stoppedBid;
    private static Long editedBid;
    private static Long pid;

    private static Campaign campaign;
    private static Context context;
    private static Map<String, Phrase> phrases;
    private static Banner stoppedBanner;
    private static Banner editedBanner;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        stoppedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        editedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(stoppedBid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(editedBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                        .withId(editedBid)
                        .withTextAd(new TextAdUpdateMap()
                                .withText(RandomStringUtils.randomAlphabetic(15)))));
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(editedBid);

        api.userSteps.adsSteps().adsSuspend(stoppedBid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        phrases = context != null && context.getPhrases() != null && context.getPhrases().size() > 0 ?
                context.getPhrases() : null;
        stoppedBanner = context != null ? context.getBanner(stoppedBid) : null;
        editedBanner = context != null ? context.getBanner(editedBid) : null;
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером и отредактированным баннером " +
            "- проверка объекта Кампания")
    public void testTransportOfCampaignObjForStoppedBannerAndEditedBanner() {
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.SKIP);
        expectedCampaign.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные кампании с одним остановленным " +
                        "и другим отредактированным баннером соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером и отредактированным баннером " +
            "- проверка объекта Контекст")
    public void testTransportOfContextObjForStoppedBannerAndEditedBanner() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные группы с остановленным баннером " +
                        "и отредактированным баннером соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером и отредактированным баннером " +
            "- проверка списка Фраз")
    public void testTransportOfPhraseListForStoppedBannerAndEditedBanner() {
        assertThat("вместе с кампанией с запущенным баннером и отредактированным " +
                        "баннером не отправлены фразы",
                phrases, nullValue());
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером и отредактированным баннером " +
            "- проверка объекта Баннер (остановленный)")
    public void testTransportOfStoppedBannerObjForStoppedBannerAndEditedBanner() {
        Banner expectedStoppedBanner = helpSteps.buildExpectedBannerObjFromDb(stoppedBid, shard, UpdateInfo.SKIP);
        expectedStoppedBanner.setStop(StopFlag.STOP.value());
        assertThat("отправленные в БК данные остановленного баннера соответствуют ожидаемым",
                stoppedBanner, beanEquals(expectedStoppedBanner));
    }

    @Test
    @Title("Отправка в БК кампании с одним остановленным баннером и другим отредактированным " +
            "- проверка объекта Баннер (отредактированный)")
    public void testTransportOfEditedBannerObjForStoppedBannerAndEditedBanner() {
        Banner expectedEditedBanner = helpSteps.buildExpectedBannerObjFromDb(editedBid, shard, UpdateInfo.UPDATE);
        expectedEditedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные отредактированного баннера соответствуют ожидаемым",
                editedBanner, beanEquals(expectedEditedBanner));
    }
}
