package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.stopping.transmit;

import java.util.List;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК остановленного баннера " +
        "и синхронизированного баннера")
@Stories(StoriesNames.BANNER_ACTION_STOPPING)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfStoppedBannerAndSyncedBannerTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();


    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long stoppedBid;
    private static Long pid;

    private static Context context;
    private static Map<String, Phrase> phrases;
    private static List<Banner> bannerList;
    private static Banner stoppedBanner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        stoppedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long bidElse = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(stoppedBid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidElse);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.adsSteps().adsSuspend(stoppedBid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        phrases = context != null && context.getPhrases() != null && context.getPhrases().size() > 0 ?
                context.getPhrases() : null;
        Map<String, Banner> banners = context != null ? context.getBanners() : null;
        bannerList = getMapValues(banners);
        stoppedBanner = context != null ? context.getBanner(stoppedBid) : null;
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером и синхронизированным баннером " +
            "- проверка объекта Контекст")
    public void testTransportOfContextObjForStoppedBannerAndSyncedBanner() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные группы с остановленным баннером соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером и синхронизированным баннером " +
            "- проверка списка Фраз")
    public void testTransportOfPhraseListForStoppedBannerAndSyncedBanner() {
        assertThat("вместе с кампанией с остановленными баннерами не отправлены фразы",
                phrases, nullValue());
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером и синхронизированным баннером " +
            "- проверка списка Баннеров")
    public void testTransportOfBannerListForStoppedBannerAndSyncedBanner() {
        assertThat("в БК отправлен список баннеров правильного размера (отправлены только остановленные)",
                bannerList, hasSize(1));
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером и синхронизированным баннером " +
            "- проверка объекта Баннер (остановленный)")
    public void testTransportOfBannerObjForStoppedBannerAndSyncedBanner() {
        Banner expectedStoppedBanner = helpSteps.buildExpectedBannerObjFromDb(stoppedBid, shard, UpdateInfo.SKIP);
        expectedStoppedBanner.setStop(StopFlag.STOP.value());
        assertThat("отправленные в БК данные остановленного баннера соответствуют ожидаемым",
                stoppedBanner, beanEquals(expectedStoppedBanner));
    }
}
