package ru.yandex.autotests.directintapi.bstransport.main.banner.actions.stopping.transmit;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК остановленного баннера с картинкой")
@Stories(StoriesNames.BANNER_ACTION_STOPPING)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfStoppedPicBannerTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long pid;
    private static Long stoppedBid;
    private static Long stoppedImageId;

    private static Campaign campaign;
    private static Context context;
    private static Map<String, Phrase> phrases;
    private static Banner stoppedBanner;
    private static Banner stoppedPic;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, REGULAR);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        stoppedBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdImageHash(imageHashes[0])));
        stoppedImageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(stoppedBid).getImageId();
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(stoppedBid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setBannerImagesStatusModerate(stoppedImageId, BannerImagesStatusmoderate.Yes);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.adsSteps().adsSuspend(stoppedBid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        phrases = context != null && context.getPhrases() != null && context.getPhrases().size() > 0 ?
                context.getPhrases() : null;
        stoppedBanner = context != null ? context.getBanner(stoppedBid) : null;
        stoppedPic = context != null ? context.getBanner(stoppedImageId) : null;
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером с картинкой - проверка объекта Кампания")
    public void testTransportOfCampaignObjForStoppedPicBanner() {
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.SKIP);
        expectedCampaign.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные кампании с остановленным баннером соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером с картинкой - проверка объекта Контекст")
    public void testTransportOfContextObjForStoppedPicBanner() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные группы с остановленным баннером соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером с картинкой - проверка списка фраз")
    public void testTransportOfPhraseListForStoppedPicBanner() {
        assertThat("вместе с кампанией с остановленными баннерами не отправлены фразы",
                phrases, nullValue());
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером с картинкой - проверка объекта Баннер")
    public void testTransportOfBannerObjForStoppedPicBanner() {
        Banner expectedStoppedBanner = helpSteps.buildExpectedBannerObjFromDb(stoppedBid, shard, UpdateInfo.SKIP);
        expectedStoppedBanner.setStop(StopFlag.STOP.value());
        assertThat("отправленные в БК данные остановленного баннера соответствуют ожидаемым",
                stoppedBanner, beanEquals(expectedStoppedBanner));
    }

    @Test
    @Title("Отправка в БК кампании с остановленным баннером с картинкой - проверка объекта Картинка")
    public void testTransportOfPicObjForStoppedPicBanner() {
        Banner expectedStoppedPic = helpSteps.buildExpectedPicBannerObjFromDb(stoppedImageId, shard, UpdateInfo.SKIP);
        expectedStoppedPic.setStop(StopFlag.STOP.value());
        assertThat("отправленные в БК данные остановленной картинки соответствуют ожидаемым",
                stoppedPic, beanEquals(expectedStoppedPic));
    }
}
