package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.autovideo;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Resources;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by bzzzz on 09.03.17.
 * https://st.yandex-team.ru/DIRECT-63953
 * https://st.yandex-team.ru/TESTIRT-11994
 *
 * NOTE: кейсы с отсутствием видео проверяются в BsTransportOfAutoVideoTest
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-63953")
@Title("Транспорт: авто-видео версии баннеров, созданные через конструктор креативов, проверка общих условий отправки")
@Stories(StoriesNames.BANNER_PARAMS_VIDEO)
@Features(FeatureNames.BANNERS)
public class BsTransportOfCreativeAutoVideoTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    private static Long cid;
    private static Long pid;

    private static Context context;
    private static Long bidWithLinkedImage;
    private static Long creativeIdWithLinkedImage;
    private static Long bidWithDeclinedVideo;
    private static Long creativeIdWithDeclinedVideo;
    private static Long bidWithAcceptedVideoTwoTypes;
    private static Long creativeIdithAcceptedVideoTwoTypes;
    private static Long imageId;

    private static RunBsTransportScriptResponse resp;

    private static DirectJooqDbSteps dbSteps;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    @BeforeClass
    public static void beforeClass() {
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(LOGIN, REGULAR);

        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        long clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID());
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        // текстовый баннер с картинкой и подключенным видео
        bidWithLinkedImage = api.userSteps.adsSteps().addAdWithAdImageHash(pid, AdGroupType.BASE, BannerType.TEXT, imageHashes[0]);
        creativeIdWithLinkedImage = dbSteps.perfCreativesSteps().saveDefaultVideoCreative(clientId, 1L);
        dbSteps.bannersPerformanceSteps().saveNewBannersPerformance(cid, pid, bidWithLinkedImage, creativeIdWithLinkedImage);
        imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(bidWithLinkedImage).getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().setBannerImagesStatusModerate(imageHashes[0], BannerImagesStatusmoderate.Yes);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithLinkedImage);
        dbSteps.bannersPerformanceSteps().setCreativeStatusModerate(cid, pid, bidWithLinkedImage, BannersPerformanceStatusmoderate.Yes);

        // текстовый баннер с отклоненным видео
        bidWithDeclinedVideo = api.userSteps.adsSteps().addDefaultAd(pid, BannerType.TEXT);
        creativeIdWithDeclinedVideo = dbSteps.perfCreativesSteps().saveDefaultVideoCreative(clientId, 1L);
        dbSteps.bannersPerformanceSteps().saveNewBannersPerformance(cid, pid, bidWithDeclinedVideo, creativeIdWithDeclinedVideo);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithDeclinedVideo);
        dbSteps.bannersPerformanceSteps().setCreativeStatusModerate(cid, pid, bidWithDeclinedVideo, BannersPerformanceStatusmoderate.No);

        // текстовый баннер с видео двух типов
        bidWithAcceptedVideoTwoTypes = api.userSteps.adsSteps().addDefaultAd(pid, BannerType.TEXT);
        creativeIdithAcceptedVideoTwoTypes = dbSteps.perfCreativesSteps().saveDefaultVideoCreative(clientId, 1L);
        dbSteps.bannersPerformanceSteps().saveNewBannersPerformance(cid, pid, bidWithAcceptedVideoTwoTypes, creativeIdithAcceptedVideoTwoTypes);
        Long videoResourceId = dbSteps.mediaResourcesSteps().createDefaultVideoResource().getMediaResourceId();
        dbSteps.bannerResourcesSteps().createBannerResource(bidWithAcceptedVideoTwoTypes, videoResourceId);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithAcceptedVideoTwoTypes);
        dbSteps.bannersPerformanceSteps().setCreativeStatusModerate(cid, pid, bidWithAcceptedVideoTwoTypes, BannersPerformanceStatusmoderate.Yes);

        // Готовим отправку в БК
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        // отправляем в БК
        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("новая кампания отправлена в БК", campaign, notNullValue());
        context = campaign.getContext(pid);
        assumeThat("группа отправлена в БК", context, notNullValue());
    }

    @Test
    @Title("Отправка в БК текстового баннера c привязанной картинкой, версия баннера - без картинки, с подключенным и допущенным видео")
    public void testBannerAutoVideoWithLinkedImageNoImageVersionWithAV() {
        Banner bannerWithImageNoImageVersion = context.getBanner(bidWithLinkedImage);
        assumeThat("текстовый баннер c привязанной картинкой, но версией для БК без картинки, отправлен в БК",
                bannerWithImageNoImageVersion, notNullValue());
        Banner expectedBannerWithVideo = new Banner()
                .withIsAutoVideo(null);
        assertThat("картиночный баннер отправился с корректными видео полями",
                bannerWithImageNoImageVersion, beanDiffer(expectedBannerWithVideo).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    @Title("Отправка в БК текстового баннера c привязанной картинкой, версия баннера - с картинкой, с подключенным и допущенным видео")
    public void testBannerAutoVideoWithLinkedImageWithAV() {
        Map<String, Map> bannerWithImageRawRequest = api.userSteps.getDarkSideSteps().getTransportSteps().getRawClientDataLogRequestForBanner(resp, cid, pid, imageId);
        assumeThat("текстовый баннер c привязанной картинкой, версией для БК с картинкой, с подключенным видео, отправлен в БК",
                bannerWithImageRawRequest, notNullValue());
        assertThat("текстовый баннер c привязанной картинкой, версия баннера - с картинкой, с подключенным видео, отправился с видео",
                bannerWithImageRawRequest.keySet(), allOf(
                        hasItem(Banner.IS_AUTO_VIDEO),
                        hasItem(Banner.RESOURCES)));
    }

    @Test
    @Title("Отправка в БК текстового баннера c привязанной картинкой, с подключенным и отклоненным видео")
    public void testBannerAutoVideoWithDeclinedAV() {
        Banner banner = context.getBanner(bidWithDeclinedVideo);
        assumeThat("текстовый баннер с подключенным и отклоненным видео отправлен в БК",
                banner, notNullValue());
        Banner expectedBannerWithVideo = new Banner()
                .withIsAutoVideo(null);
        assertThat("текстовый баннер с подключенным и отклоненным видео отправился с корректными видео полями",
                banner, beanDiffer(expectedBannerWithVideo).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    @Title("Отправка в БК текстового баннера c привязанной картинкой, с подключенным и допущенным видео и записью о видео старого типа")
    public void testBannerAutoVideoWithAcceptedAVAndOldStyleAV() {
        Banner actualBanner = context.getBanner(bidWithAcceptedVideoTwoTypes);
        assumeThat("текстовый баннер с подключенным и допущенным видео отправлен в БК",
                actualBanner, notNullValue());
        Banner expectedBanner = new Banner()
                .withIsAutoVideo(1)
                .withResources(
                        new Resources()
                                .withAutoVideoCreative(creativeIdithAcceptedVideoTwoTypes));
        assertThat("текстовый баннер с подключенным и допущенным видео отправлен в БК с корректными видеополями (от видео нового типа)",
                actualBanner, beanDiffer(expectedBanner).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @AfterClass
    public static void afterClass() {
        List<Long> creativeIds = Arrays.asList(creativeIdWithLinkedImage, creativeIdWithDeclinedVideo, creativeIdithAcceptedVideoTwoTypes);

        dbSteps.bannersPerformanceSteps().deleteBannersPerformanceRecords(creativeIds);
        dbSteps.perfCreativesSteps().deletePerfCreatives(creativeIds);
    }
}
