package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.callouts;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.CalloutSet;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 25/04/16.
 * https://st.yandex-team.ru/TESTIRT-9029
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-53054")
@Title("Транспорт: уточнения для баннеров, порядок")
@Stories(StoriesNames.BANNER_PARAMS_CALLOUTS)
@Features(FeatureNames.BANNERS)
public class BsTransportCalloutOrderTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String FIRST_TEXT = RandomUtils.getString(15);
    private static final String SECOND_TEXT = RandomUtils.getString(15);
    private static final String THIRD_TEXT = RandomUtils.getString(15);
    private static int shard;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps dbSteps;
    private static CalloutSet calloutSet;
    private static CalloutSet calloutSetElse;
    private static Long firstCalloutId;
    private static Long secondCalloutId;
    private static Long thirdCalloutId;

    @BeforeClass
    public static void init() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        dbSteps = new DirectJooqDbSteps().useShard(shard);
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long bidElse = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        firstCalloutId = api.userSteps.adExtensionsSteps().addCalloutWithText(FIRST_TEXT);
        secondCalloutId = api.userSteps.adExtensionsSteps().addCalloutWithText(SECOND_TEXT);
        thirdCalloutId = api.userSteps.adExtensionsSteps().addCalloutWithText(THIRD_TEXT);
        dbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(firstCalloutId
                , AdditionsItemCalloutsStatusmoderate.Yes);
        dbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(secondCalloutId
                , AdditionsItemCalloutsStatusmoderate.Yes);
        dbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(thirdCalloutId
                , AdditionsItemCalloutsStatusmoderate.Yes);
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                                .withId(bid)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(firstCalloutId)
                                                                .withOperation(OperationEnum.ADD),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(secondCalloutId)
                                                                .withOperation(OperationEnum.ADD),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(thirdCalloutId)
                                                                .withOperation(OperationEnum.ADD)))),
                        new AdUpdateItemMap()
                                .withId(bidElse)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(thirdCalloutId)
                                                                .withOperation(OperationEnum.ADD),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(secondCalloutId)
                                                                .withOperation(OperationEnum.ADD),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(firstCalloutId)
                                                                .withOperation(OperationEnum.ADD)))))
        );

        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidElse);

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("в контексте присутствует Banner", banner, notNullValue());
        calloutSet = banner.getCalloutSet();
        assumeThat("в баннере присутствует CalloutSet", calloutSet, notNullValue());
        Banner bannerElse = context.getBanner(bidElse);
        assumeThat("в контексте присутствует Banner", bannerElse, notNullValue());
        calloutSetElse = bannerElse.getCalloutSet();
        assumeThat("в баннере присутствует CalloutSet", calloutSetElse, notNullValue());

    }

    @Test
    public void testBannerCalloutListOrder() {
        CalloutSet expectedCalloutSet = new CalloutSet();
        Map<Long, String> expectedCallouts = new HashMap<>();
        expectedCallouts.put(firstCalloutId, FIRST_TEXT);
        expectedCallouts.put(secondCalloutId, SECOND_TEXT);
        expectedCallouts.put(thirdCalloutId, THIRD_TEXT);
        expectedCalloutSet.setCallouts(expectedCallouts);
        expectedCalloutSet.setCalloutsList(Arrays.asList(FIRST_TEXT, SECOND_TEXT, THIRD_TEXT));
        assertThat("при отправке баннера с уточнениями отправляется правильный СalloutSet"
                , calloutSet, beanDiffer(expectedCalloutSet));
    }

    @Test
    public void testBannerCalloutListBackwardOrder() {
        CalloutSet expectedCalloutSet = new CalloutSet();
        Map<Long, String> expectedCallouts = new HashMap<>();
        expectedCallouts.put(thirdCalloutId, THIRD_TEXT);
        expectedCallouts.put(secondCalloutId, SECOND_TEXT);
        expectedCallouts.put(firstCalloutId, FIRST_TEXT);
        expectedCalloutSet.setCallouts(expectedCallouts);
        expectedCalloutSet.setCalloutsList(Arrays.asList(THIRD_TEXT, SECOND_TEXT, FIRST_TEXT));
        assertThat("при отправке баннера с уточнениями отправляется правильный СalloutSet"
                , calloutSetElse, beanDiffer(expectedCalloutSet));
    }

}
