package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.callouts;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.CalloutSet;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 25/01/16.
 * https://st.yandex-team.ru/TESTIRT-8311
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-48839")
@Title("Транспорт: уточнения для баннеров")
@Stories(StoriesNames.BANNER_PARAMS_CALLOUTS)
@Features(FeatureNames.BANNERS)
public class BsTransportCalloutTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String CALLOUT_TEXT = RandomUtils.getString(15);
    private static int shard;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps dbSteps;
    private static CalloutSet calloutSet;
    private static Long calloutId;

    @BeforeClass
    public static void init() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        dbSteps = new DirectJooqDbSteps().useShard(shard);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        calloutId = api.userSteps.adExtensionsSteps().addCalloutWithText(CALLOUT_TEXT);
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                        .withId(bid)
                        .withTextAd(new TextAdUpdateMap()
                                .withCalloutSetting(new AdExtensionSettingMap()
                                        .withAdExtensions(new AdExtensionSettingItemMap()
                                                .withAdExtensionId(calloutId)
                                                .withOperation(OperationEnum.ADD)))))
        );

        dbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(calloutId
                , AdditionsItemCalloutsStatusmoderate.Yes);

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("в контексте присутствует Banner", banner, notNullValue());
        calloutSet = banner.getCalloutSet();
        assumeThat("в баннере присутствует CalloutSet", calloutSet, notNullValue());
    }

    @Test
    public void testBannerCalloutSet() {
        CalloutSet expectedCalloutSet = new CalloutSet();
        Map<Long, String> expectedCallouts = new HashMap<>();
        expectedCallouts.put(calloutId, CALLOUT_TEXT);
        expectedCalloutSet.setCallouts(expectedCallouts);
        expectedCalloutSet.setCalloutsList(Arrays.asList(CALLOUT_TEXT));
        assertThat("при отправке баннера с уточнением отправляется СalloutSet правильного размера"
                , calloutSet, beanDiffer(expectedCalloutSet));
    }
}
