package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.callouts;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.CalloutSet;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 25/01/16.
 * https://st.yandex-team.ru/TESTIRT-8311
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-48839")
@Title("Транспорт: уточнения для баннеров, несколько уточнений/баннеров")
@Stories(StoriesNames.BANNER_PARAMS_CALLOUTS)
@Features(FeatureNames.BANNERS)
public class BsTransportMultipleCalloutTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String FIRST_TEXT = RandomUtils.getString(15);
    private static final String SECOND_TEXT = RandomUtils.getString(15);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps dbSteps;
    private static Long firstCalloutId;
    private static Long secondCalloutId;
    private static int shard;
    private static Long cid;
    private Long bid;
    private Long bidAnother;
    private Long pid;

    @BeforeClass
    public static void init() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        dbSteps = new DirectJooqDbSteps().useShard(shard);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        firstCalloutId = api.userSteps.adExtensionsSteps().addCalloutWithText(FIRST_TEXT);
        secondCalloutId = api.userSteps.adExtensionsSteps().addCalloutWithText(SECOND_TEXT);
        dbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(firstCalloutId
                , AdditionsItemCalloutsStatusmoderate.Yes);
        dbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(secondCalloutId
                , AdditionsItemCalloutsStatusmoderate.Yes);
    }


    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidAnother = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }

    @Test
    @Title("Отправка 2х баннеров: один содержит 2 уточнения, второй без уточнений")
    public void testBannerTwoCalloutsForOneBanner() {
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                        .withId(bid)
                        .withTextAd(new TextAdUpdateMap()
                                .withCalloutSetting(new AdExtensionSettingMap()
                                        .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(firstCalloutId)
                                                        .withOperation(OperationEnum.ADD),
                                                new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(secondCalloutId)
                                                        .withOperation(OperationEnum.ADD)))))
        );
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("в контексте присутствует Banner", banner, notNullValue());
        CalloutSet calloutSet = banner.getCalloutSet();

        CalloutSet expectedCalloutSet = new CalloutSet();
        Map<Long, String> expectedCallouts = new HashMap<>();
        expectedCallouts.put(firstCalloutId, FIRST_TEXT);
        expectedCallouts.put(secondCalloutId, SECOND_TEXT);
        expectedCalloutSet.setCallouts(expectedCallouts);
        expectedCalloutSet.setCalloutsList(Arrays.asList(FIRST_TEXT, SECOND_TEXT));

        assertThat("при отправке баннера с уточнением отправляется правильное поле СalloutSet"
                , calloutSet, beanDiffer(expectedCalloutSet));
    }

    @Test
    @Title("Отправка 2х баннеров с уточнениями")
    public void testTwoBannersEachWithCallout() {
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                                .withId(bid)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(firstCalloutId)
                                                        .withOperation(OperationEnum.ADD)))),
                        new AdUpdateItemMap()
                                .withId(bidAnother)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(secondCalloutId)
                                                        .withOperation(OperationEnum.ADD)))))
        );
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidAnother);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("в контексте присутствует Banner", banner, notNullValue());
        CalloutSet calloutSet = banner.getCalloutSet();
        assumeThat("в баннере присутствует CalloutSet", calloutSet, notNullValue());

        Banner bannerAnother = context.getBanner(bidAnother);
        assumeThat("в контексте присутствует Banner", bannerAnother, notNullValue());
        CalloutSet calloutSetAnother = bannerAnother.getCalloutSet();
        assumeThat("в баннере присутствует CalloutSet", calloutSetAnother, notNullValue());

        assertThat("при отправке баннера с уточнениями отправляется непустой правильного размера"
                , calloutSet.getCallouts().get(firstCalloutId), notNullValue());
        assertThat("при отправке баннера с уточнениями отправляется СalloutSet правильного размера"
                , calloutSetAnother.getCallouts().get(secondCalloutId), notNullValue());
    }

    @Test
    @Title("Отправка 2х баннеров: один содержит уточненине, второй - без уточнений")
    public void testTwoBannersOnlyOneWithCallout() {
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                        .withId(bid)
                        .withTextAd(new TextAdUpdateMap()
                                .withCalloutSetting(new AdExtensionSettingMap()
                                        .withAdExtensions(new AdExtensionSettingItemMap()
                                                .withAdExtensionId(firstCalloutId)
                                                .withOperation(OperationEnum.ADD)))))
        );
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidAnother);


        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("в контексте присутствует Banner", banner, notNullValue());
        Banner bannerAnother = context.getBanner(bidAnother);
        assumeThat("в контексте присутствует Banner", bannerAnother, notNullValue());
        CalloutSet calloutSetAnother = bannerAnother.getCalloutSet();
        assertThat("в баннере отсутствует CalloutSet", calloutSetAnother, nullValue());
    }

    @Test
    @Title("Отправка 2х баннеров с одинаковыми уточнениями")
    public void testTwoBannersEachWithSameCallout() {
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                                .withId(bid)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(firstCalloutId)
                                                        .withOperation(OperationEnum.ADD)))),
                        new AdUpdateItemMap()
                                .withId(bidAnother)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(firstCalloutId)
                                                        .withOperation(OperationEnum.ADD)))))
        );
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidAnother);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("в контексте присутствует Banner", banner, notNullValue());
        CalloutSet calloutSet = banner.getCalloutSet();
        assumeThat("в баннере присутствует CalloutSet", calloutSet, notNullValue());

        Banner bannerAnother = context.getBanner(bidAnother);
        assumeThat("в контексте присутствует Banner", bannerAnother, notNullValue());
        CalloutSet calloutSetAnother = bannerAnother.getCalloutSet();
        assumeThat("в баннере присутствует CalloutSet", calloutSetAnother, notNullValue());

        assertThat("при отправке баннера с уточнениями отправляется СalloutSet правильного размера"
                , calloutSet.getCallouts().get(firstCalloutId), notNullValue());
        assertThat("при отправке баннера с уточнениями отправляется СalloutSet правильного размера"
                , calloutSetAnother.getCallouts().get(firstCalloutId), notNullValue());
    }

    @Test
    @Title("Отправка 2х баннеров, содержащих и уточнения и сайтилинки")
    public void testTwoBannersWithCalloutsAndSiteLinks() {

        List<Long> sitelinksSetIds = api.userSteps.sitelinksSteps().add(new AddRequestMap()
                .withSitelinksSets(
                        new SitelinksSetAddItemMap().withSitelinks(
                                new SitelinkMap().randomSitelinkWithDescription(),
                                new SitelinkMap().randomSitelinkWithDescription()),
                        new SitelinksSetAddItemMap().withSitelinks(
                                new SitelinkMap().randomSitelinkWithDescription(),
                                new SitelinkMap().randomSitelinkWithDescription(),
                                new SitelinkMap().randomSitelinkWithDescription(),
                                new SitelinkMap().randomSitelinkWithDescription())));


        assumeThat("был добавлено два набора сайтлинков", sitelinksSetIds, hasSize(2));
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                                .withId(bid)
                                .withTextAd(new TextAdUpdateMap()
                                        .withSitelinkSetId(sitelinksSetIds.get(0))
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(firstCalloutId)
                                                        .withOperation(OperationEnum.ADD)))),
                        new AdUpdateItemMap()
                                .withId(bidAnother)
                                .withTextAd(new TextAdUpdateMap()
                                        .withSitelinkSetId(sitelinksSetIds.get(1))
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(firstCalloutId)
                                                        .withOperation(OperationEnum.ADD)))))
        );

        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidAnother);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("в контексте присутствует Banner", banner, notNullValue());
        CalloutSet calloutSet = banner.getCalloutSet();
        assumeThat("в баннере присутствует CalloutSet", calloutSet, notNullValue());

        Banner bannerAnother = context.getBanner(bidAnother);
        assumeThat("в контексте присутствует Banner", bannerAnother, notNullValue());
        CalloutSet calloutSetAnother = bannerAnother.getCalloutSet();
        assumeThat("в баннере присутствует CalloutSet", calloutSetAnother, notNullValue());

        assertThat("при отправке баннера с уточнениями отправляется СalloutSet правильного размера"
                , calloutSet.getCallouts().get(firstCalloutId), notNullValue());
        assertThat("при отправке баннера с уточнениями отправляется СalloutSet правильного размера"
                , calloutSetAnother.getCallouts().get(firstCalloutId), notNullValue());
    }
}
