package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.disclaimer;

import java.util.Map;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ClientDataStdLogEntry;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ClientDataStdRequest;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 23/11/16.
 * https://st.yandex-team.ru/TESTIRT-10639
 */

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-60642")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Отправка динамического дисклеймера")
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfDynamicDisclaimerTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String DISCLAIMER_TEXT = RandomUtils.getString(70);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private long additionsId;
    private Long cid;
    private Long pid;
    private Long bid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }


    @Test
    @Title("Отправка баннера с динамическим дисклеймером")
    public void transportВannerDynamicDisclaimer() {
        additionsId = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveAdditionsItemDisclaimers(Long.valueOf(User.get(LOGIN).getClientID()), DISCLAIMER_TEXT);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveBannerAdditions(bid, additionsId, BannersAdditionsAdditionsType.disclaimer);
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("в БК отправлен баннер c UpdateInfo=1", banner.getUpdateInfo(), equalTo(1));
        assertThat("поле DynamicDisclaimer соответствует ожидаемому",
                banner.getDynamicDisclaimer(), equalTo(DISCLAIMER_TEXT));
    }

    @Test
    @Title("Отправка остановки баннера с динамическим дисклеймером(UpdateInfo=0)")
    public void transportВannerDynamicDisclaimerWithoutUpdateInfo() {
        additionsId = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveAdditionsItemDisclaimers(Long.valueOf(User.get(LOGIN).getClientID()), DISCLAIMER_TEXT);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveBannerAdditions(bid, additionsId, BannersAdditionsAdditionsType.disclaimer);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(bid, Status.NO);
        api.userSteps.bannersFakeSteps().setStatusModerate(bid, Status.NO);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(bid, Status.REJECTED);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Map<String, Map> campaignMap = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getRawClientDataLogEntriesForCampaign(resp, cid);
        Map<String, Map> logEntryReq1 = campaignMap.get(resp.getUuid()[0]);
        Map<String, Map> requestReq1 = logEntryReq1 != null ?
                logEntryReq1.get(ClientDataStdLogEntry.REQUEST) : null;
        Map<String, Map> ordersReq1 = requestReq1 != null ?
                requestReq1.get(ClientDataStdRequest.ORDERS) : null;
        Map<String, Map> orderReq1 = ordersReq1 != null ?
                ordersReq1.get(String.valueOf(cid)) : null;
        Map<String, Map> contextsReq1 = orderReq1 != null ?
                orderReq1.get(Campaign.CONTEXTS) : null;
        Map<String, Map> contextReq1 = contextsReq1 != null ?
                contextsReq1.get(String.valueOf(pid)) : null;
        Map<String, Map> bannersReq1 = contextReq1 != null ?
                contextReq1.get(Context.BANNERS) : null;
        Map<String, Object> banner = bannersReq1 != null ?
                bannersReq1.get(String.valueOf(bid)) : null;

        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("в БК отправлен баннер c UpdateInfo=0", banner.get(Banner.UPDATE_INFO), equalTo(0));
        assumeThat("поле DynamicDisclaimer не отправляется c UpdateInfo=0 даже при наличии дисклеймера",
                banner.keySet().contains(Banner.DYNAMIC_DISCLAIMER), is(false));
    }

    @Test
    @Title("Отправка 2х баннеров один из которых с динамическим дисклеймером")
    public void transportTwoВannersOneWithDynamicDisclaimer() {
        additionsId = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveAdditionsItemDisclaimers(Long.valueOf(User.get(LOGIN).getClientID()), DISCLAIMER_TEXT);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveBannerAdditions(bid, additionsId, BannersAdditionsAdditionsType.disclaimer);

        Long bidWithoutDisclaimer = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithoutDisclaimer);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        Banner bannerWithoutDisclaimer = context != null ? context.getBanner(bidWithoutDisclaimer) : null;
        assumeThat("в БК отправлен первый баннер", banner, notNullValue());
        assumeThat("в БК отправлен первый баннер c UpdateInfo=1", banner.getUpdateInfo(), equalTo(1));
        assumeThat("в БК отправлен второй баннер", bannerWithoutDisclaimer, notNullValue());
        assumeThat("в БК отправлен второй баннер c UpdateInfo=1", bannerWithoutDisclaimer.getUpdateInfo(), equalTo(1));
        assumeThat("для второго баннера не отправлен DynamicDisclaimer",
                bannerWithoutDisclaimer.getDynamicDisclaimer(), nullValue());
        assertThat("поле DynamicDisclaimer первого баннера соответствует ожидаемому",
                banner.getDynamicDisclaimer(), equalTo(DISCLAIMER_TEXT));
    }

    @Test
    @Title("Отправка баннера с динамическим дисклеймером")
    public void transportВannerWithOutDynamicDisclaimer() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Map<String, Map> campaignMap = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getRawClientDataLogEntriesForCampaign(resp, cid);
        Map<String, Map> logEntryReq1 = campaignMap.get(resp.getUuid()[0]);
        Map<String, Map> requestReq1 = logEntryReq1 != null ?
                logEntryReq1.get(ClientDataStdLogEntry.REQUEST) : null;
        Map<String, Map> ordersReq1 = requestReq1 != null ?
                requestReq1.get(ClientDataStdRequest.ORDERS) : null;
        Map<String, Map> orderReq1 = ordersReq1 != null ?
                ordersReq1.get(String.valueOf(cid)) : null;
        Map<String, Map> contextsReq1 = orderReq1 != null ?
                orderReq1.get(Campaign.CONTEXTS) : null;
        Map<String, Map> contextReq1 = contextsReq1 != null ?
                contextsReq1.get(String.valueOf(pid)) : null;
        Map<String, Map> bannersReq1 = contextReq1 != null ?
                contextReq1.get(Context.BANNERS) : null;
        Map<String, Object> banner = bannersReq1 != null ?
                bannersReq1.get(String.valueOf(bid)) : null;

        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("в БК отправлен баннер c UpdateInfo=1", banner.get(Banner.UPDATE_INFO), equalTo(1));
        assumeThat("поле DynamicDisclaimer отправляется даже если нет дисклеймера",
                banner.keySet().contains(Banner.DYNAMIC_DISCLAIMER), is(true));
        assertThat("поле DynamicDisclaimer отправляется даже если нет дисклеймера",
                banner.get(Banner.DYNAMIC_DISCLAIMER), nullValue());
    }

    @After
    public void clear() {
        if (additionsId > 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteBannerAdditions(
                    bid, additionsId
            );
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteAdditionsItemDisclaimers(
                    additionsId
            );
        }
    }
}
