package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.disclaimer;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 23/11/16.
 * https://st.yandex-team.ru/TESTIRT-10639
 */

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-60642")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Отправка двух баннеров с разными динамическоими дисклеймерами")
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfDynamicDisclaimerTwoBannerDifferentDisclaimersTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String DISCLAIMER_TEXT_1 = RandomUtils.getString(70);
    private static final String DISCLAIMER_TEXT_2 = RandomUtils.getString(70);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private static long additionsId;
    private static long additionsIdAnother;
    private static Long bid;
    private static Long bidAnother;
    private static Context context;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidAnother = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidAnother);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        additionsId = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveAdditionsItemDisclaimers(Long.valueOf(User.get(LOGIN).getClientID()), DISCLAIMER_TEXT_1);
        additionsIdAnother = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveAdditionsItemDisclaimers(Long.valueOf(User.get(LOGIN).getClientID()), DISCLAIMER_TEXT_2);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveBannerAdditions(bid, additionsId, BannersAdditionsAdditionsType.disclaimer);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveBannerAdditions(bidAnother, additionsIdAnother, BannersAdditionsAdditionsType.disclaimer);

        Long bidWithoutDisclaimer = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithoutDisclaimer);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
    }

    @Test
    @Title("Отправка 2х баннеров с динамическим дисклеймером, проверка первого")
    public void transportTwoВannersWithDynamicDisclaimerFirstBanner() {
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен первый баннер", banner, notNullValue());
        assumeThat("в БК отправлен первый баннер c UpdateInfo=1", banner.getUpdateInfo(), equalTo(1));
        assertThat("поле DynamicDisclaimer первого баннера соответствует ожидаемому",
                banner.getDynamicDisclaimer(), equalTo(DISCLAIMER_TEXT_1));
    }

    @Test
    @Title("Отправка 2х баннеров с динамическим дисклеймером, проверка второго")
    public void transportTwoВannersWithDynamicDisclaimerSecondBanner() {
        Banner banner = context != null ? context.getBanner(bidAnother) : null;
        assumeThat("в БК отправлен второй баннер", banner, notNullValue());
        assumeThat("в БК отправлен второй баннер c UpdateInfo=1", banner.getUpdateInfo(), equalTo(1));
        assertThat("поле DynamicDisclaimer второго баннера соответствует ожидаемому",
                banner.getDynamicDisclaimer(), equalTo(DISCLAIMER_TEXT_2));
    }

    @AfterClass
    public static void clear() {
        if (additionsId > 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteBannerAdditions(
                    bid, additionsId
            );
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteAdditionsItemDisclaimers(
                    additionsId
            );
        }
        if (additionsIdAnother > 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteBannerAdditions(
                    bidAnother, additionsIdAnother
            );
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteAdditionsItemDisclaimers(
                    additionsIdAnother
            );
        }
    }
}
