package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.disclaimer;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 23/11/16.
 * https://st.yandex-team.ru/TESTIRT-10639
 */

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-60642")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Отправка динамического дисклеймера для картиночного баннера")
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfDynamicDisclaimerWithImageBannerTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_REGULAR;
    private static final String DISCLAIMER_TEXT = RandomUtils.getString(70);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static Context context;
    private static int shard;
    private static long additionsId;
    private static Long cid;
    private static Long pid;
    private static Long bid;
    private static Long imageId;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(LOGIN, ImageType.REGULAR);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdImageHash(imageHashes[0])));
        imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(bid).getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        additionsId = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveAdditionsItemDisclaimers(Long.valueOf(User.get(LOGIN).getClientID()), DISCLAIMER_TEXT);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveBannerAdditions(bid, additionsId, BannersAdditionsAdditionsType.disclaimer);

        Long bidWithoutDisclaimer = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithoutDisclaimer);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
    }

    @Test
    @Title("Отправка баннера с картинкой и динамическим дисклеймером, проверка текстовой части")
    public void transportTwoВannersWithDynamicDisclaimerFirstBanner() {
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлена текстовая часть баннера", banner, notNullValue());
        assumeThat("в БК отправлена текстовая часть баннера c UpdateInfo=1", banner.getUpdateInfo(), equalTo(1));
        assertThat("поле DynamicDisclaimer первого баннера соответствует ожидаемому",
                banner.getDynamicDisclaimer(), equalTo(DISCLAIMER_TEXT));
    }

    @Test
    @Title("Отправка баннера с картинкой и динамическим дисклеймером, проверка картиночной части")
    public void transportTwoВannersWithDynamicDisclaimerSecondBanner() {
        Banner banner = context != null ? context.getBanner(imageId) : null;
        assumeThat("в БК отправлена картиночная часть баннера", banner, notNullValue());
        assumeThat("в БК отправлена картиночная часть баннера c UpdateInfo=1", banner.getUpdateInfo(), equalTo(1));
        assertThat("поле DynamicDisclaimer второго баннера соответствует ожидаемому",
                banner.getDynamicDisclaimer(), equalTo(DISCLAIMER_TEXT));
    }

    @AfterClass
    public static void clear() {
        if (additionsId > 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteBannerAdditions(
                    bid, additionsId
            );
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteAdditionsItemDisclaimers(
                    additionsId
            );
        }
    }
}
