package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.displayeddomainalias;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsContentPromotionContentPromotionType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerPermalinksPermalinkAssignType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.OrganizationsStatusPublish;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.OrganizationsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-118201")
@Title("Транспорт: проверка отправки в БК DisplayedDomainAlias на баннере")
@Features({FeatureNames.BANNERS})
public class BsTransportOfDisplayedDomainAlias {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    private static int shard;
    private static DirectJooqDbSteps jooqDbSteps;
    private static Long campaignId;
    private static Long adGroupId;

    private long bannerId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
    }

    @Before
    public void setUp() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(campaignId);

        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        bannerId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        Long keywordId = api.userSteps.keywordsSteps().addRandomKeyword(adGroupId);

        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bannerId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(adGroupId);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }

    @Test
    @Title("DisplayedDomainAlias of yandex.ru/collections")
    public void collections_tgo() {
        checkTgoHref("https://yandex.ru/collections/123321", "collections");
    }

    @Test
    @Title("DisplayedDomainAlias of yandex.com/collections")
    public void collections_tgo_com() {
        checkTgoHref("https://yandex.com/collections/123321", "collections");
    }

    @Test
    @Title("DisplayedDomainAlias of collections.yandex.com")
    public void collections_tgo_specialDomain() {
        checkTgoHref("https://collections.yandex.com/123321", "collections");
    }

    @Test
    @Title("DisplayedDomainAlias of yandex.ru/sprav")
    public void sprav_tgo() {
        checkTgoHref("https://yandex.ru/sprav/123321", "sprav");
    }

    @Test
    @Title("DisplayedDomainAlias of yandex.uz/sprav")
    public void sprav_tgo_uz() {
        checkTgoHref("https://yandex.uz/sprav/123321", "sprav");
    }

    @Test
    @Title("DisplayedDomainAlias of sprav.yandex.by")
    public void sprav_tgo_specialDomain() {
        checkTgoHref("https://sprav.yandex.by/123321", "sprav");
    }

    @Test
    @Title("DisplayedDomainAlias of permalink")
    public void sprav_tgo_permalink() {
        Long permalink = org.apache.commons.lang.math.RandomUtils.nextLong();
        jooqDbSteps.bannerAdditionsSteps().setPermalink(bannerId, permalink, 0L, BannerPermalinksPermalinkAssignType.manual);
        OrganizationsRecord record = new OrganizationsRecord()
                .setPermalinkId(permalink)
                .setStatusPublish(OrganizationsStatusPublish.published)
                .setClientid(Long.valueOf(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID()));
        jooqDbSteps.bannerAdditionsSteps().addOrUpdateOrganization(record);
        checkTgoHref(null, "sprav");
    }

    @Test
    @Title("DisplayedDomainAlias of contentPromotion")
    public void sprav_contentPromotion() {
        jooqDbSteps.campaignsSteps().setPlatform(campaignId, CampaignsPlatform.search);
        jooqDbSteps.campaignsSteps().setType(campaignId, CampaignsType.content_promotion);
        jooqDbSteps.adGroupsSteps().setType(adGroupId, PhrasesAdgroupType.content_promotion);
        jooqDbSteps.bannersSteps().setBannersBannerType(bannerId, BannersBannerType.content_promotion);
        jooqDbSteps.adGroupsContentPromotionSteps().addAdGroupContentPromotion(adGroupId,
                AdgroupsContentPromotionContentPromotionType.collection);
        checkTgoHref("https://yandex.ru/collections/user/mg-gloria-jeans/kollektsiia-gloria-jeans-letnii-fleshbek/", "collections");
    }

    @Test
    @Title("DisplayedDomainAlias of yandex.ru/maps")
    public void maps_tgo() {
        checkTgoHref("https://yandex.ru/maps/123321", "maps");
    }

    @Test
    @Title("DisplayedDomainAlias of yandex.com.tr/maps")
    public void maps_tgo_domainTr() {
        checkTgoHref("https://yandex.com.tr/maps/123321", "maps");
    }

    @Test
    @Title("DisplayedDomainAlias of maps.yandex.ru")
    public void maps_tgo_specialDomain() {
        checkTgoHref("https://maps.yandex.ru/123321", "maps");
    }

    @Test
    @Title("DisplayedDomainAlias of maps.yandex.com.tr")
    public void maps_tgo_specialDomainTr() {
        checkTgoHref("https://maps.yandex.com.tr/123321", "maps");
    }

    @Test
    @Title("DisplayedDomainAlias of yandex.ru/web-maps")
    public void maps_tgo_specialWebDomain() {
        checkTgoHref("https://yandex.ru/web-maps/123321", "maps");
    }

    @Test
    @Title("DisplayedDomainAlias of yandex.com.tr/web-maps")
    public void maps_tgo_specialWebDomainTr() {
        checkTgoHref("https://yandex.com.tr/web-maps/123321", "maps");
    }

    private void checkTgoHref(String href, String displayedDomainAlias) {
        jooqDbSteps.bannersSteps().setBannersHref(bannerId, href);
        checkDisplayedDomainAlias(displayedDomainAlias);
    }

    private void checkDisplayedDomainAlias(String displayedDomainAlias) {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, campaignId);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, campaignId);
        Context context = campaign.getContext(adGroupId);
        Banner banner = context.getBanner(bannerId);

        assertThat("Коорректное значение DisplayedDomainAlias", banner.getDisplayedDomainAlias(), displayedDomainAlias == null ? nullValue() : equalTo(displayedDomainAlias));
    }
}
