package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.experiment;

import java.util.Map;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Resources;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.google.common.base.Preconditions.checkNotNull;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.isOneOf;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.darkside.steps.TransportSteps.getBsClientDataBanner;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-70573")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Отправка эксперимента на баннер")
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfExperimentTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String EXPERIMENT_JSON = "{\"feild1\":\"value1\"}";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private long additionsId;
    private Long cid;
    private Long pid;
    private Long bid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }

    @After
    public void clear() {
        if (additionsId > 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteBannerAdditions(
                    bid, additionsId
            );
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteAdditionsItemExperiments(
                    additionsId
            );
        }
    }

    @Test
    @Title("Отправка баннера с экспериментом")
    public void transportВannerExperiment() {
        additionsId = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveAdditionsItemExperiments(Long.valueOf(User.get(LOGIN).getClientID()), EXPERIMENT_JSON);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveBannerAdditions(bid, additionsId, BannersAdditionsAdditionsType.experiment);
        RunBsTransportScriptResponse
                resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Banner banner = getBsClientDataBanner(campaign, pid, bid);
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("в БК отправлен баннер c UpdateInfo=1", banner.getUpdateInfo(), equalTo(1));
        assertThat("поле Experiment соответствует ожидаемому",
                banner.getResources().getExperiment(), equalTo(EXPERIMENT_JSON));
    }

    @Test
    @Title("Отправка остановки баннера с экспериментом (UpdateInfo=0)")
    public void transportВannerExperimentWithoutUpdateInfo() {
        additionsId = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveAdditionsItemExperiments(Long.valueOf(User.get(LOGIN).getClientID()), EXPERIMENT_JSON);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveBannerAdditions(bid, additionsId, BannersAdditionsAdditionsType.experiment);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(bid, Status.NO);
        api.userSteps.bannersFakeSteps().setStatusModerate(bid, Status.NO);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(bid, Status.REJECTED);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Map<String, Map> banner = api.userSteps.getDarkSideSteps().getTransportSteps().getRawClientDataLogRequestForBanner(resp, cid, pid, bid);

        assumeThat("в БК отправлен баннер", banner, notNullValue());
        // если верить структуре banner - то все значения это другие словари, однако это не так
        // noinspection RedundantCast - без явного приведения запуск из IDEA может падать с ошибкой ClassCastException
        assumeThat("в БК отправлен баннер c UpdateInfo=0", (Object) banner.get(Banner.UPDATE_INFO), equalTo(0));
        assumeThat("поле Resources не отправляется c UpdateInfo=0 даже при наличии эксперимента",
                banner.keySet(), not(hasItem(Banner.RESOURCES)));
    }

    @Test
    @Title("Отправка баннера без эксперимента")
    public void transportBannerWithOutExperiment() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        Resources resources = banner != null ? banner.getResources() : null;
        String experiment = resources != null ? resources.getExperiment() : null;

        assumeThat("в БК отправлен баннер", banner, notNullValue());
        checkNotNull(banner); // глушилка ворнинга на возможный NPE
        assumeThat("в БК отправлен баннер c UpdateInfo=1", banner.getUpdateInfo(), equalTo(1));
        assumeThat("поле Resources.Experiment не отправляется если нет эксперимента",
                experiment, isOneOf("null", null));
    }
}
